/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.graph;

import com.mastfrog.abstractions.list.IndexedResolvable;
import com.mastfrog.graph.ObjectPath;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.IntConsumer;

public final class IntPath
implements Comparable<IntPath>,
Iterable<Integer> {
    private static int DEFAULT_SIZE = 12;
    private int[] items;
    private int size;

    private IntPath(int size, int[] items) {
        this.size = size;
        this.items = Arrays.copyOf(items, size + DEFAULT_SIZE);
    }

    IntPath(int initialItems) {
        this.items = new int[initialItems];
    }

    IntPath() {
        this(DEFAULT_SIZE);
    }

    IntPath copy() {
        return new IntPath(this.size, this.items);
    }

    public int first() {
        if (this.size == 0) {
            throw new IndexOutOfBoundsException("Empty");
        }
        return this.items[0];
    }

    public int last() {
        if (this.size == 0) {
            throw new IndexOutOfBoundsException("empty");
        }
        return this.items[this.size - 1];
    }

    private void growIfNeeded() {
        if (this.size == this.items.length - 1) {
            this.items = Arrays.copyOf(this.items, this.items.length + DEFAULT_SIZE);
        }
    }

    public IntPath addAll(int ... values) {
        if (this.size + values.length < this.items.length) {
            this.items = Arrays.copyOf(this.items, this.items.length + values.length);
        }
        System.arraycopy(values, 0, this.items, this.size, values.length);
        this.size += values.length;
        return this;
    }

    IntPath add(int item) {
        this.growIfNeeded();
        this.items[this.size++] = item;
        return this;
    }

    IntPath append(IntPath other) {
        int targetSize = this.size() + other.size();
        if (this.items.length < targetSize) {
            this.items = Arrays.copyOf(this.items, targetSize);
        }
        System.arraycopy(other.items, 0, this.items, this.size, other.size());
        this.size = targetSize;
        return this;
    }

    IntPath trim() {
        this.items = Arrays.copyOf(this.items, this.size);
        return this;
    }

    public IntPath childPath() {
        if (this.size == 0) {
            return this;
        }
        int[] nue = new int[this.size - 1];
        System.arraycopy(this.items, 1, nue, 0, nue.length);
        return new IntPath(nue.length, nue);
    }

    public IntPath parentPath() {
        if (this.size == 0) {
            return this;
        }
        int[] nue = new int[this.size - 1];
        System.arraycopy(this.items, 0, nue, 0, nue.length);
        return new IntPath(nue.length, nue);
    }

    IntPath replace(int index, IntPath other) {
        this.size = index;
        this.append(other);
        return this;
    }

    public IntPath reversed() {
        int[] nue = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            nue[i] = this.items[this.size - (i + 1)];
        }
        return new IntPath(this.size, nue);
    }

    public int start() {
        return this.size == 0 ? -1 : this.items[0];
    }

    public int end() {
        return this.size == 0 ? -1 : this.items[this.size - 1];
    }

    public boolean contains(IntPath path) {
        if (path.size() > this.size) {
            return false;
        }
        if (path.size() == this.size) {
            return path.equals(this);
        }
        for (int i = 0; i < this.size - path.size(); ++i) {
            if (!IntPath.arraysEquals(this.items, i, i + path.size(), path.items, 0, path.size())) continue;
            return true;
        }
        return false;
    }

    public static boolean arraysEquals(int[] a, int aFromIndex, int aToIndex, int[] b, int bFromIndex, int bToIndex) {
        int aLength = aToIndex - aFromIndex;
        int bLength = bToIndex - bFromIndex;
        if (aLength != bLength) {
            return false;
        }
        while (aFromIndex < aToIndex && bFromIndex < bToIndex) {
            if (a[aFromIndex] != b[bFromIndex]) {
                return false;
            }
            ++aFromIndex;
            ++bFromIndex;
        }
        return true;
    }

    public int indexOf(int val) {
        for (int i = 0; i < this.size; ++i) {
            if (this.get(i) != val) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(int val) {
        for (int i = 0; i < this.size; ++i) {
            if (val != this.get(i)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public int get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException(index + " of " + this.size);
        }
        return this.items[index];
    }

    public int[] items() {
        return this.size == this.items.length ? this.items : Arrays.copyOf(this.items, this.size);
    }

    public void iterate(IntConsumer cons) {
        for (int i = 0; i < this.size; ++i) {
            cons.accept(this.get(i));
        }
        cons.accept(-1);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof IntPath) {
            return Arrays.equals(this.items(), ((IntPath)o).items());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.items());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(24);
        for (int i = 0; i < this.size(); ++i) {
            int value = this.get(i);
            if (sb.length() != 0) {
                sb.append(',');
            }
            sb.append(value);
        }
        return sb.toString();
    }

    public <T> ObjectPath<T> toObjectPath(IndexedResolvable<T> indexed) {
        return new ObjectPath<T>(this, indexed);
    }

    @Override
    public int compareTo(IntPath o) {
        int b;
        int a = this.size();
        return a > (b = o.size()) ? 1 : (a < b ? -1 : 0);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new IIt();
    }

    class IIt
    implements Iterator<Integer> {
        int pos = -1;

        IIt() {
        }

        @Override
        public boolean hasNext() {
            return this.pos + 1 < IntPath.this.size();
        }

        @Override
        public Integer next() {
            return IntPath.this.get(++this.pos);
        }
    }
}

