/*
 * Decompiled with CFR 0.152.
 */
package com.mastertechsoftware.tasker;

import com.mastertechsoftware.tasker.Condition;
import com.mastertechsoftware.tasker.Pausable;
import com.mastertechsoftware.tasker.Task;
import com.mastertechsoftware.tasker.Tasker;

public abstract class DefaultTask<T>
implements Task<T> {
    protected Tasker.THREAD_TYPE threadType = Tasker.THREAD_TYPE.BACKGROUND;
    protected boolean shouldContinue = true;
    protected Pausable pauseable;
    protected Exception error;
    protected Condition condition;
    protected T result;
    protected T previousTaskResult;

    public DefaultTask() {
    }

    public DefaultTask(Tasker.THREAD_TYPE threadType) {
        this.threadType = threadType;
    }

    @Override
    public void setPauseable(Pausable pauseable) {
        this.pauseable = pauseable;
    }

    public void setPaused(boolean paused) {
        if (this.pauseable != null) {
            this.pauseable.setPaused(paused);
        }
    }

    @Override
    public Exception getError() {
        return this.error;
    }

    @Override
    public boolean hasError() {
        return this.error != null;
    }

    @Override
    public void setError(Exception error) {
        this.error = error;
    }

    @Override
    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    @Override
    public Condition getCondition() {
        return this.condition;
    }

    @Override
    public boolean hasCondition() {
        return this.condition != null;
    }

    @Override
    public void setResult(T result) {
        this.result = result;
    }

    @Override
    public T getResult() {
        return this.result;
    }

    @Override
    public T getPreviousResult() {
        return this.previousTaskResult;
    }

    @Override
    public void setPreviousResult(T result) {
        this.previousTaskResult = result;
    }

    @Override
    public boolean shouldContinue() {
        return this.shouldContinue;
    }

    public void setShouldContinue(boolean shouldContinue) {
        this.shouldContinue = shouldContinue;
    }

    @Override
    public Tasker.THREAD_TYPE runType() {
        return this.threadType;
    }

    @Override
    public void setRunType(Tasker.THREAD_TYPE threadType) {
        this.threadType = threadType;
    }

    @Override
    public abstract Object run();
}

