/*
 * Decompiled with CFR 0.152.
 */
package com.mastertechsoftware.tasker;

import android.os.Handler;
import com.mastertechsoftware.tasker.Condition;
import com.mastertechsoftware.tasker.Pausable;
import com.mastertechsoftware.tasker.Task;
import com.mastertechsoftware.tasker.Tasker;

public abstract class DefaultTask
implements Task {
    protected Handler handler = new Handler();
    protected Tasker.THREAD_TYPE threadType = Tasker.THREAD_TYPE.BACKGROUND;
    protected boolean shouldContinue = true;
    protected Pausable pauseable;
    protected Exception error;
    protected Condition condition;
    protected Object result;

    public DefaultTask() {
    }

    public DefaultTask(Tasker.THREAD_TYPE threadType) {
        this.threadType = threadType;
    }

    @Override
    public void setPauseable(Pausable pauseable) {
        this.pauseable = pauseable;
    }

    public void setPaused(boolean paused) {
        if (this.pauseable != null) {
            this.pauseable.setPaused(paused);
        }
    }

    @Override
    public Exception getError() {
        return this.error;
    }

    @Override
    public Object getResult() {
        return this.result;
    }

    @Override
    public boolean hasError() {
        return this.error != null;
    }

    @Override
    public void setError(Exception error) {
        this.error = error;
    }

    @Override
    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    @Override
    public Condition getCondition() {
        return this.condition;
    }

    @Override
    public boolean hasCondition() {
        return this.condition != null;
    }

    @Override
    public void setResult(Object result) {
        this.result = result;
    }

    @Override
    public boolean shouldContinue() {
        return this.shouldContinue;
    }

    public void setShouldContinue(boolean shouldContinue) {
        this.shouldContinue = shouldContinue;
    }

    @Override
    public Tasker.THREAD_TYPE runType() {
        return this.threadType;
    }

    @Override
    public void setRunType(Tasker.THREAD_TYPE threadType) {
        this.threadType = threadType;
    }

    public void runOnUIThread(Runnable runnable) {
        this.handler.post(runnable);
    }

    @Override
    public abstract Object run();
}

