/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.developer.signers;

import com.mastercard.developer.oauth.OAuth;
import com.mastercard.developer.signers.AbstractSigner;
import java.nio.charset.Charset;
import java.security.PrivateKey;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.MediaType;

public class SpringHttpRequestSigner
extends AbstractSigner {
    public SpringHttpRequestSigner(String consumerKey, PrivateKey signingKey) {
        super(consumerKey, signingKey);
    }

    public void sign(HttpRequest request, byte[] bytes) {
        HttpHeaders headers = request.getHeaders();
        Charset charset = SpringHttpRequestSigner.getCharset(headers);
        String payload = null == bytes ? null : new String(bytes, charset);
        String authHeader = OAuth.getAuthorizationHeader(request.getURI(), request.getMethod().toString(), payload, charset, this.consumerKey, this.signingKey);
        headers.add("Authorization", authHeader);
    }

    private static Charset getCharset(HttpHeaders headers) {
        Charset charset;
        Charset defaultCharset = Charset.defaultCharset();
        MediaType contentType = headers.getContentType();
        if (contentType != null && (charset = contentType.getCharset()) != null) {
            return charset;
        }
        return defaultCharset;
    }
}

