/*
 * Decompiled with CFR 0.152.
 */
package com.master.simplerrecyclerviewadapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;

public final class SimplerRecyclerViewAdapter<M>
extends RecyclerView.Adapter<ViewHolder> {
    private ArrayList<M> mList = new ArrayList();
    private ArrayList<Integer> resLayoutList = new ArrayList();
    private ArrayList<SimplerViewHolder> viewHolderList = new ArrayList();

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (this.resLayoutList.size() <= 0) {
            throw new RuntimeException("You forgot to add ViewHolder, please add view holder using SimplerRecyclerViewAdapter.addViewHolder() method");
        }
        return new ViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(this.resLayoutList.get(viewType).intValue(), parent, false), this.viewHolderList.get(viewType));
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        holder.bind(this.getItem(position));
    }

    public int getItemViewType(int position) {
        if (this.viewHolderList != null) {
            int pos = 0;
            for (SimplerViewHolder simplerViewHolder : this.viewHolderList) {
                if (simplerViewHolder.isMyViewType(this.getItem(position))) {
                    return pos;
                }
                ++pos;
            }
        }
        return super.getItemViewType(position);
    }

    public M getItem(int position) {
        return this.mList.get(position);
    }

    public void addViewHolder(int resLayout, SimplerViewHolder<M> simplerViewHolder) {
        this.resLayoutList.add(resLayout);
        this.viewHolderList.add(simplerViewHolder);
    }

    public int getItemCount() {
        return this.mList.size();
    }

    public void setList(ArrayList<M> list) {
        this.mList.clear();
        this.mList.addAll(list);
        this.notifyDataSetChanged();
    }

    public void addList(ArrayList<M> list) {
        this.mList.addAll(list);
        this.notifyDataSetChanged();
    }

    public void updateItem(int position, M model) {
        this.mList.set(position, model);
        this.notifyDataSetChanged();
    }

    public void removeItem(int position) {
        this.mList.remove(position);
        this.notifyDataSetChanged();
    }

    public static abstract class SimplerViewHolder<M> {
        public abstract void create(View var1);

        public abstract void bind(M var1);

        public boolean isMyViewType(M model) {
            return false;
        }
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        SimplerViewHolder viewHolder;

        public ViewHolder(View itemView, SimplerViewHolder viewHolder) {
            super(itemView);
            this.viewHolder = viewHolder;
            this.viewHolder.create(itemView);
        }

        public void bind(M model) {
            this.viewHolder.bind(model);
        }
    }
}

