/*
 * Decompiled with CFR 0.152.
 */
package master.library;

import android.text.format.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class SuperCalendar {
    Calendar mCalendar = Calendar.getInstance();
    private static SuperCalendar superCalendar;
    TimeZone mTimeZone = this.mCalendar.getTimeZone();

    private SuperCalendar() {
    }

    public static final SuperCalendar getInstance() {
        superCalendar = new SuperCalendar();
        return superCalendar;
    }

    public Calendar getCalendar() {
        return this.mCalendar;
    }

    public void setTime(Date date) {
        this.mCalendar.setTime(date);
    }

    public void setTimeInMillis(long millis) {
        this.mCalendar.setTimeInMillis(millis);
    }

    public void setLocaleTimeZone() {
        this.mTimeZone = TimeZone.getDefault();
        this.mCalendar.setTimeZone(this.mTimeZone);
    }

    public void setTimeZone(String timeZone) {
        this.mTimeZone = TimeZone.getTimeZone(timeZone);
        this.mCalendar.setTimeZone(this.mTimeZone);
    }

    public void setTimeInString(String dateTime, String formatOfThisDate) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(formatOfThisDate);
        this.mCalendar.setTime(simpleDateFormat.parse(dateTime));
        this.mCalendar.setTimeZone(this.mTimeZone);
    }

    public String format(String formatDate) {
        return DateFormat.format((CharSequence)formatDate, (Calendar)this.mCalendar).toString();
    }

    public SuperCalendar getWeekStartDate() {
        try {
            SuperCalendar superCalendar = this.clone();
            superCalendar.mCalendar.set(7, 1);
            return superCalendar;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return this;
        }
    }

    public SuperCalendar getWeekEndDate() {
        try {
            SuperCalendar superCalendar = this.clone();
            superCalendar.mCalendar.set(7, 7);
            return superCalendar;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return this;
        }
    }

    public long getTimeInMillis() {
        return this.mCalendar.getTimeInMillis();
    }

    public String toString() {
        return this.mCalendar.get(5) + "/" + this.mCalendar.get(2) + "/" + this.mCalendar.get(1) + " " + this.mCalendar.get(11) + ":" + this.mCalendar.get(12) + ":" + this.mCalendar.get(13) + ":" + this.mCalendar.get(14);
    }

    protected SuperCalendar clone() throws CloneNotSupportedException {
        SuperCalendar superCalendar = SuperCalendar.getInstance();
        superCalendar.mCalendar = (Calendar)this.mCalendar.clone();
        superCalendar.mCalendar.setTimeZone(this.mCalendar.getTimeZone());
        return superCalendar;
    }

    public void set(int field, int value) {
        this.mCalendar.set(field, value);
    }

    public static interface SuperFormatter {
        public static final String HOUR_24_HOUR = "HH";
        public static final String HOUR_12_HOUR_2_DIGIT = "hh";
        public static final String HOUR_12_HOUR_1_DIGIT = "h";
        public static final String MINUTE = "mm";
        public static final String SECONDS = "ss";
        public static final String MILLISECONDS = "SSS";
        public static final String AM_PM = "a";
        public static final String DATE = "dd";
        public static final String MONTH_JAN = "MMM";
        public static final String MONTH_JANUARY = "MMMM";
        public static final String MONTH_NUMBER = "MM";
        public static final String YEAR_4_DIGIT = "yyyy";
        public static final String YEAR_2_DIGIT = "yy";
        public static final String WEEK_SUNDAY = "EEEE";
        public static final String WEEK_SUN = "EEE";
    }

    public static interface SuperTimeZone {

        public static interface IST {
            public static final String ASIA_CALCUTTA = "Asia/Calcutta";
        }

        public static interface GMT {
            public static final String GMT = "GMT";
        }
    }
}

