package master.library;

import android.text.format.DateFormat;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

/**
 * Created by pankaj on 11/27/16.
 */

public class SuperCalendar {
    Calendar mCalendar;
    private static SuperCalendar superCalendar;
    TimeZone mTimeZone;

    private SuperCalendar() {
        mCalendar = Calendar.getInstance();
        mTimeZone = mCalendar.getTimeZone();
    }

    public static final SuperCalendar getInstance() {
        superCalendar = new SuperCalendar();
        return superCalendar;
    }

    //========
    public Calendar getCalendar() {
        return mCalendar;
    }

    public void setTime(Date date) {
        mCalendar.setTime(date);
    }

    public void setTimeInMillis(long millis) {
        mCalendar.setTimeInMillis(millis);
    }

    public void setLocaleTimeZone() {
        mTimeZone = TimeZone.getDefault();
        mCalendar.setTimeZone(mTimeZone);
    }

    public void setTimeZone(String timeZone) {
        mTimeZone = TimeZone.getTimeZone(timeZone);
        mCalendar.setTimeZone(mTimeZone);
    }

    public void setTimeInString(String dateTime, String formatOfThisDate) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(formatOfThisDate);
        mCalendar.setTime(simpleDateFormat.parse(dateTime));
        mCalendar.setTimeZone(mTimeZone);
    }

    public String format(String formatDate) {
        return DateFormat.format(formatDate, mCalendar).toString();
    }

    public SuperCalendar getWeekStartDate() {
        try {
            SuperCalendar superCalendar = clone();
            superCalendar.mCalendar.set(Calendar.DAY_OF_WEEK, 1);
            return superCalendar;
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return this;
    }

    public SuperCalendar getWeekEndDate() {
        try {
            SuperCalendar superCalendar = clone();
            superCalendar.mCalendar.set(Calendar.DAY_OF_WEEK, 7);
            return superCalendar;
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return this;
    }

    public long getTimeInMillis() {
        return mCalendar.getTimeInMillis();
    }

    //Override to string
    @Override
    public String toString() {
        return mCalendar.get(Calendar.DATE) + "/" + mCalendar.get(Calendar.MONTH) + "/" + mCalendar.get(Calendar.YEAR) + " " + mCalendar.get(Calendar.HOUR_OF_DAY) + ":" + mCalendar.get(Calendar.MINUTE) + ":" + mCalendar.get(Calendar.SECOND) + ":" + mCalendar.get(Calendar.MILLISECOND);
    }

    @Override
    protected SuperCalendar clone() throws CloneNotSupportedException {
        SuperCalendar superCalendar = SuperCalendar.getInstance();
        superCalendar.mCalendar = (Calendar) mCalendar.clone();
        superCalendar.mCalendar.setTimeZone(mCalendar.getTimeZone());
        return superCalendar;
    }

    public void set(int field, int value) {
        mCalendar.set(field, value);
    }

    public interface SuperTimeZone {
        interface GMT {
            public final String GMT = "GMT";
        }

        interface IST {
            public final String ASIA_CALCUTTA = "Asia/Calcutta";
        }
    }


    public static interface SuperFormatter {
        //COMMON FORMATS, DONT CHANGE THE COMMON FORMATS
        public static final String HOUR_24_HOUR = "HH";
        public static final String HOUR_12_HOUR_2_DIGIT = "hh";
        public static final String HOUR_12_HOUR_1_DIGIT = "h";
        public static final String MINUTE = "mm";
        public static final String SECONDS = "ss";
        public static final String MILLISECONDS = "SSS";

        public static final String AM_PM = "a";

        public static final String DATE = "dd";

        public static final String MONTH_JAN = "MMM";
        public static final String MONTH_JANUARY = "MMMM";
        public static final String MONTH_NUMBER = "MM";

        public static final String YEAR_4_DIGIT = "yyyy";
        public static final String YEAR_2_DIGIT = "yy";

        public static final String WEEK_SUNDAY = "EEEE";
        public static final String WEEK_SUN = "EEE";
    }
}