package master.library;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.support.v4.content.ContextCompat;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.MotionEvent;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Created by pankaj on 2/11/17.
 */

public class CommonUtils {
    public static void makeClearableEditText(final EditText editText, final int res, String defaultValue, final View.OnClickListener clickListener) {

        final String defaultText = defaultValue == null ? editText.getText().toString().trim() : defaultValue;
        final View.OnTouchListener onTouchListener = new View.OnTouchListener() {
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                final int DRAWABLE_LEFT = 0;
                final int DRAWABLE_TOP = 1;
                final int DRAWABLE_RIGHT = 2;
                final int DRAWABLE_BOTTOM = 3;

                if (event.getAction() == MotionEvent.ACTION_UP) {
                    if (event.getRawX() >= (editText.getRight() - editText.getCompoundDrawables()[DRAWABLE_RIGHT].getBounds().width())) {
                        // your action here
                        editText.setOnTouchListener(null);
                        editText.setText(defaultText);
                        clickListener.onClick(editText);
                        return true;
                    }
                }
                return false;
            }
        };
        editText.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void afterTextChanged(Editable editable) {
                if (TextUtils.isEmpty(editText.getText().toString().trim()) || defaultText.equalsIgnoreCase(editText.getText().toString().trim())) {
                    editText.setCompoundDrawablesWithIntrinsicBounds(editText.getCompoundDrawables()[0], editText.getCompoundDrawables()[1], editText.getCompoundDrawables()[2], editText.getCompoundDrawables()[3]);
                    editText.setOnTouchListener(null);
                } else {
                    editText.setCompoundDrawablesWithIntrinsicBounds(editText.getCompoundDrawables()[0], editText.getCompoundDrawables()[1], ContextCompat.getDrawable(editText.getContext(), res), editText.getCompoundDrawables()[3]);
                    editText.setOnTouchListener(onTouchListener);
                }
            }
        });
    }

    private static ArrayList<Object> list;

    public static void saveInPref(Context context, Object user) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(context.getString(R.string.app_name), Context.MODE_PRIVATE);
        sharedPreferences.edit().putString(user.getClass().getSimpleName(), getJsonStringFromObject(user)).commit();
        int i = 0;
        if (list != null) {
            boolean isFound = false;
            for (Object object : list) {
                if (object.getClass() == user.getClass()) {
                    list.set(i, user);
                    isFound = true;
                    break;
                }
                i++;
            }
            if (isFound == false) {
                list.add(user);
            }
        }
    }

    /**
     * GSON UTILITY Methods
     */

    private static Gson gson = new GsonBuilder().create();

    public static <T> Object getObjectFromJsonString(String jsonData, Class modelClass) {
        return gson.fromJson(jsonData, modelClass);
    }

    public static String getJsonStringFromObject(Object modelClass) {
        return gson.toJson(modelClass);
    }

    public static <T> String getJsonStringFromObject(List<T> objectArrayList) {
        return gson.toJson(objectArrayList, new TypeToken<List<T>>() {
        }.getType());
    }

    public static <T> ArrayList<T> getObjectListFromJsonString(String jsonData, Class myclass) {
        return new ArrayList<>(Arrays.asList((T[]) gson.fromJson(jsonData, myclass)));
    }

    public static int DEVICE_WIDTH, DEVICE_HEIGHT;

    public static int[] getDeviceWidthHeight(Activity activity) {

        int size[] = new int[2];

        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.ICE_CREAM_SANDWICH) {
            DisplayMetrics displayMetrics = activity.getResources()
                    .getDisplayMetrics();
            size[0] = displayMetrics.widthPixels;
            size[1] = displayMetrics.heightPixels;
            DEVICE_WIDTH = size[0];
            DEVICE_HEIGHT = size[1];
        } else {
            Display mDisplay = activity.getWindowManager().getDefaultDisplay();
            size[0] = mDisplay.getWidth();
            size[1] = mDisplay.getHeight();
            DEVICE_WIDTH = size[0];
            DEVICE_HEIGHT = size[1];
        }
        return size;
    }
}
