/*
 * Decompiled with CFR 0.152.
 */
package com.massivedisaster.adal.network;

import android.content.Context;
import com.google.gson.Gson;
import com.massivedisaster.adal.network.APIError;
import com.massivedisaster.adal.network.APIErrorListener;
import com.massivedisaster.adal.network.R;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.net.UnknownHostException;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public abstract class APICallback<T extends APIErrorListener>
implements Callback<T> {
    private Context mContext;

    public APICallback(Context context) {
        this.mContext = context;
    }

    public abstract void onSuccess(T var1);

    public abstract void onError(APIError var1, boolean var2);

    public void onResponse(Call<T> call, Response<T> response) {
        if (call.isCanceled()) {
            return;
        }
        if (response == null) {
            this.processError(new APIError(this.mContext.getString(R.string.error_network_general)), true);
            return;
        }
        if (response.errorBody() != null) {
            Gson gson = new Gson();
            try {
                APIErrorListener error = (APIErrorListener)gson.fromJson(response.errorBody().string(), ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0]);
                if (error != null) {
                    this.processError(new APIError(error.getError()), true);
                    return;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.processError(new APIError(this.mContext.getString(R.string.error_network_general)), true);
            return;
        }
        if (response.body() == null && !response.isSuccessful()) {
            this.processError(new APIError(this.mContext.getString(R.string.error_network_general)), true);
            return;
        }
        this.onSuccess((APIErrorListener)response.body());
    }

    public void onFailure(Call<T> call, Throwable t) {
        if (call.isCanceled()) {
            return;
        }
        if (t != null) {
            t.printStackTrace();
            if (t instanceof UnknownHostException && t.getMessage() != null) {
                this.processError(new APIError(this.mContext.getString(R.string.error_network_no_connection)), true);
                return;
            }
        }
        this.processError(new APIError(this.mContext.getString(R.string.error_network_general)), true);
    }

    private void processError(APIError error, boolean serverError) {
        this.onError(error, serverError);
    }
}

