/*
 * Decompiled with CFR 0.152.
 */
package com.massivedisaster.adal.analytics;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.Tracker;

public class AnalyticsManager {
    private static AnalyticsManager sInstance;
    private Tracker mTracker;
    private final Context mContext;

    public static synchronized AnalyticsManager with(@NonNull Context context) {
        if (sInstance == null) {
            sInstance = new AnalyticsManager(context);
        }
        return sInstance;
    }

    private AnalyticsManager(@NonNull Context context) {
        this.mContext = context.getApplicationContext();
        this.getTracker();
    }

    private synchronized Tracker getTracker() {
        if (this.mTracker == null) {
            int checkExistence = this.mContext.getResources().getIdentifier("global_tracker", "xml", this.mContext.getPackageName());
            if (checkExistence == 0) {
                Log.e((String)AnalyticsManager.class.getCanonicalName(), (String)"Please check if you have global-services.json");
            } else {
                this.mTracker = GoogleAnalytics.getInstance((Context)this.mContext).newTracker(checkExistence);
                this.mTracker.enableAutoActivityTracking(false);
                this.mTracker.enableAdvertisingIdCollection(false);
                this.mTracker.enableExceptionReporting(false);
            }
        }
        return this.mTracker;
    }

    public synchronized void sendScreen(int screenId, String ... label) {
        if (screenId == 0) {
            return;
        }
        if (label == null) {
            this.sendScreen(this.mContext.getString(screenId));
        } else {
            this.sendScreen(this.mContext.getString(screenId, (Object[])label));
        }
    }

    public synchronized void sendScreen(@NonNull String screenName) {
        if (this.getTracker() == null) {
            return;
        }
        this.mTracker.setScreenName(screenName);
        this.mTracker.send(new HitBuilders.ScreenViewBuilder().build());
    }

    public synchronized void sendScreen(@NonNull int resScreenName) {
        if (this.getTracker() == null) {
            return;
        }
        this.sendScreen(this.mContext.getString(resScreenName));
    }

    public synchronized void sendEvent(int categoryId, int actionId) {
        this.sendEvent(categoryId, actionId, null);
    }

    public synchronized void sendEvent(int categoryId, int actionId, String label) {
        if (this.getTracker() == null) {
            return;
        }
        if (categoryId == 0 || actionId == 0) {
            return;
        }
        HitBuilders.EventBuilder builder = new HitBuilders.EventBuilder().setCategory(this.mContext.getString(categoryId)).setAction(this.mContext.getString(actionId));
        if (label != null) {
            builder.setLabel(label);
        }
        this.mTracker.send(builder.build());
    }
}

