/*
 * Decompiled with CFR 0.152.
 */
package com.massivedisaster.adal.analytics;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.ecommerce.Product;
import com.google.android.gms.analytics.ecommerce.ProductAction;
import com.google.android.gms.analytics.ecommerce.Promotion;

public final class AnalyticsManager {
    private static AnalyticsManager sInstance;
    private final Context mContext;
    private Tracker mTracker;

    private AnalyticsManager(@NonNull Context context) {
        this.mContext = context.getApplicationContext();
        this.getTracker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AnalyticsManager with(@NonNull Context context) {
        Context context2 = context;
        synchronized (context2) {
            if (sInstance == null) {
                sInstance = new AnalyticsManager(context);
            }
            return sInstance;
        }
    }

    private Tracker getTracker() {
        if (this.mTracker == null) {
            int checkExistence = this.mContext.getResources().getIdentifier("global_tracker", "xml", this.mContext.getPackageName());
            if (checkExistence == 0) {
                Log.e((String)AnalyticsManager.class.getCanonicalName(), (String)"Please check if you have global-services.json");
            } else {
                this.mTracker = GoogleAnalytics.getInstance((Context)this.mContext).newTracker(checkExistence);
                this.mTracker.enableAutoActivityTracking(false);
                this.mTracker.enableAdvertisingIdCollection(false);
                this.mTracker.enableExceptionReporting(false);
            }
        }
        return this.mTracker;
    }

    public void sendScreen(int screenId, String ... label) {
        if (screenId == 0) {
            return;
        }
        if (label == null) {
            this.sendScreen(this.mContext.getString(screenId));
        } else {
            this.sendScreen(this.mContext.getString(screenId, (Object[])label));
        }
    }

    public void sendScreen(@NonNull String screenName) {
        if (this.getTracker() == null) {
            return;
        }
        this.mTracker.setScreenName(screenName);
        this.mTracker.send(new HitBuilders.ScreenViewBuilder().build());
    }

    public void sendScreen(@NonNull Integer resScreenName) {
        if (this.getTracker() == null) {
            return;
        }
        this.sendScreen(this.mContext.getString(resScreenName.intValue()));
    }

    public void sendEvent(int categoryId, int actionId) {
        this.sendEvent(categoryId, actionId, null);
    }

    public void sendEvent(int categoryId, int actionId, String label) {
        if (this.getTracker() == null) {
            return;
        }
        if (categoryId == 0 || actionId == 0) {
            return;
        }
        HitBuilders.EventBuilder builder = new HitBuilders.EventBuilder().setCategory(this.mContext.getString(categoryId)).setAction(this.mContext.getString(actionId));
        if (label != null) {
            builder.setLabel(label);
        }
        this.mTracker.send(builder.build());
    }

    public void sendImpression(@NonNull Product product, @NonNull String label, @NonNull String screenName) {
        if (this.getTracker() == null || product == null) {
            return;
        }
        HitBuilders.ScreenViewBuilder builder = (HitBuilders.ScreenViewBuilder)new HitBuilders.ScreenViewBuilder().addImpression(product, label);
        this.mTracker.setScreenName(screenName);
        this.mTracker.send(builder.build());
    }

    public void sendProduct(@NonNull ProductAction action, @Nullable Product product, @Nullable String impressionList, @NonNull String screenName) {
        if (this.getTracker() == null) {
            return;
        }
        HitBuilders.ScreenViewBuilder builder = new HitBuilders.ScreenViewBuilder();
        if (impressionList != null) {
            builder.addImpression(product, impressionList);
        }
        if (product != null) {
            builder.addProduct(product);
        }
        builder.setProductAction(action);
        this.mTracker.setScreenName(screenName);
        this.mTracker.send(builder.build());
    }

    public void sendPromotion(@NonNull Promotion promotion, @NonNull String screenName) {
        if (this.getTracker() == null) {
            return;
        }
        HitBuilders.ScreenViewBuilder builder = (HitBuilders.ScreenViewBuilder)new HitBuilders.ScreenViewBuilder().addPromotion(promotion);
        this.mTracker.setScreenName(screenName);
        this.mTracker.send(builder.build());
    }

    public void sendPromotionAction(@NonNull Promotion promotion, @NonNull String promotionAction, @Nullable String category, @Nullable String action, @Nullable String label, @NonNull String screenName) {
        if (this.getTracker() == null) {
            return;
        }
        HitBuilders.EventBuilder builder = (HitBuilders.EventBuilder)((HitBuilders.EventBuilder)new HitBuilders.EventBuilder().addPromotion(promotion)).setPromotionAction(promotionAction);
        if (category != null) {
            builder.setCategory(category);
        }
        if (action != null) {
            builder.setAction(action);
        }
        if (label != null) {
            builder.setLabel(label);
        }
        this.mTracker.setScreenName(screenName);
        this.mTracker.send(builder.build());
    }
}

