/*
 * Decompiled with CFR 0.152.
 */
package com.massivedisaster.adal.analytics;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.util.Log;
import com.google.firebase.analytics.FirebaseAnalytics;
import java.util.Map;

public final class FirebaseAnalyticsManager {
    private FirebaseAnalyticsManager() {
    }

    public static void sendScreen(Activity activity, @StringRes int screenNameId) {
        FirebaseAnalyticsManager.sendScreen(activity, screenNameId, null);
    }

    public static void sendScreen(Activity activity, @StringRes int screenNameId, String label) {
        if (screenNameId == 0) {
            Log.w((String)FirebaseAnalyticsManager.class.getCanonicalName(), (String)"You need a screenName to send the Screen");
            return;
        }
        if (label == null) {
            FirebaseAnalyticsManager.sendScreen(activity, activity.getString(screenNameId));
        } else {
            FirebaseAnalyticsManager.sendScreen(activity, activity.getString(screenNameId, new Object[]{label}));
        }
    }

    public static void sendScreen(Activity activity, String screenName) {
        if (TextUtils.isEmpty((CharSequence)screenName)) {
            Log.w((String)FirebaseAnalyticsManager.class.getCanonicalName(), (String)"You need a screenName to send the Screen");
            return;
        }
        FirebaseAnalytics.getInstance((Context)activity).setCurrentScreen(activity, screenName, null);
    }

    public static void sendEvent(Activity activity, @StringRes int eventNameId, Map<String, String> eventInfo) {
        if (eventNameId == 0) {
            Log.w((String)FirebaseAnalyticsManager.class.getCanonicalName(), (String)"You need a eventNameId to send the Event");
            return;
        }
        FirebaseAnalyticsManager.sendEvent(activity, activity.getString(eventNameId), eventInfo);
    }

    public static void sendEvent(Activity activity, String eventName, Map<String, String> eventInfo) {
        if (TextUtils.isEmpty((CharSequence)eventName)) {
            Log.w((String)FirebaseAnalyticsManager.class.getCanonicalName(), (String)"You need a eventName to send the Event");
            return;
        }
        if (eventInfo == null || eventInfo.isEmpty()) {
            Log.w((String)FirebaseAnalyticsManager.class.getCanonicalName(), (String)"You need a eventInfo to send the Event");
            return;
        }
        Bundle bundle = new Bundle();
        for (Map.Entry<String, String> entry : eventInfo.entrySet()) {
            bundle.putString(entry.getKey(), entry.getValue());
        }
        FirebaseAnalytics.getInstance((Context)activity).logEvent(eventName, bundle);
    }

    public static void sendUserProperty(Activity activity, @StringRes int propertyId, @StringRes int valueId) {
        if (valueId == 0) {
            Log.w((String)FirebaseAnalyticsManager.class.getCanonicalName(), (String)"You need a valueId to send the User Property");
            return;
        }
        FirebaseAnalyticsManager.sendUserProperty(activity, propertyId, activity.getString(valueId));
    }

    public static void sendUserProperty(Activity activity, @StringRes int propertyId, String value) {
        if (propertyId == 0) {
            Log.w((String)FirebaseAnalyticsManager.class.getCanonicalName(), (String)"You need a propertyId to send the User Property");
            return;
        }
        FirebaseAnalyticsManager.sendUserProperty(activity, activity.getString(propertyId), value);
    }

    public static void sendUserProperty(Activity activity, String property, String value) {
        if (TextUtils.isEmpty((CharSequence)property)) {
            Log.w((String)FirebaseAnalyticsManager.class.getCanonicalName(), (String)"You need a property to send the User Property");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)value)) {
            Log.w((String)FirebaseAnalyticsManager.class.getCanonicalName(), (String)"You need a value to send the User Property");
            return;
        }
        FirebaseAnalytics.getInstance((Context)activity).setUserProperty(property, value);
    }
}

