/*
 * Decompiled with CFR 0.152.
 */
package com.massivedisaster.adal.analytics;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.Tracker;

public final class AnalyticsManager {
    private static AnalyticsManager sInstance;
    private final Context mContext;
    private Tracker mTracker;

    private AnalyticsManager(@NonNull Context context) {
        this.mContext = context.getApplicationContext();
        this.getTracker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AnalyticsManager with(@NonNull Context context) {
        Context context2 = context;
        synchronized (context2) {
            if (sInstance == null) {
                sInstance = new AnalyticsManager(context);
            }
            return sInstance;
        }
    }

    private Tracker getTracker() {
        if (this.mTracker == null) {
            int checkExistence = this.mContext.getResources().getIdentifier("global_tracker", "xml", this.mContext.getPackageName());
            if (checkExistence == 0) {
                Log.e((String)AnalyticsManager.class.getCanonicalName(), (String)"Please check if you have global-services.json");
            } else {
                this.mTracker = GoogleAnalytics.getInstance((Context)this.mContext).newTracker(checkExistence);
                this.mTracker.enableAutoActivityTracking(false);
                this.mTracker.enableAdvertisingIdCollection(false);
                this.mTracker.enableExceptionReporting(false);
            }
        }
        return this.mTracker;
    }

    public void sendScreen(int screenId, String ... label) {
        if (screenId == 0) {
            return;
        }
        if (label == null) {
            this.sendScreen(this.mContext.getString(screenId));
        } else {
            this.sendScreen(this.mContext.getString(screenId, (Object[])label));
        }
    }

    public void sendScreen(@NonNull String screenName) {
        if (this.getTracker() == null) {
            return;
        }
        this.mTracker.setScreenName(screenName);
        this.mTracker.send(new HitBuilders.ScreenViewBuilder().build());
    }

    public void sendScreen(@NonNull Integer resScreenName) {
        if (this.getTracker() == null) {
            return;
        }
        this.sendScreen(this.mContext.getString(resScreenName.intValue()));
    }

    public void sendEvent(int categoryId, int actionId) {
        this.sendEvent(categoryId, actionId, null);
    }

    public void sendEvent(int categoryId, int actionId, String label) {
        if (this.getTracker() == null) {
            return;
        }
        if (categoryId == 0 || actionId == 0) {
            return;
        }
        HitBuilders.EventBuilder builder = new HitBuilders.EventBuilder().setCategory(this.mContext.getString(categoryId)).setAction(this.mContext.getString(actionId));
        if (label != null) {
            builder.setLabel(label);
        }
        this.mTracker.send(builder.build());
    }
}

