/*
 * Decompiled with CFR 0.152.
 */
package com.massivedisaster.adal.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.massivedisaster.adal.adapter.BaseViewHolder;
import java.util.List;

public abstract class AbstractBaseAdapter<T>
extends RecyclerView.Adapter<BaseViewHolder> {
    private static final int sViewTypeItem = 0;
    private static final int sViewTypeLoad = 1;
    private OnChildClickListener<T> mListener;
    private OnLoadMoreListener mOnLoadMoreListener;
    private List<T> mLstItems;
    private int mResLayout;
    private int mResLoading;
    private boolean isLoading = false;
    private boolean isMoreDataAvailable = true;
    private boolean isLoadingError = false;

    public AbstractBaseAdapter(int resLayout, List<T> lstItems) {
        this.init(resLayout, -1, lstItems);
    }

    public AbstractBaseAdapter(int resLayout, int resLoading, List<T> lstItems) {
        this.init(resLayout, resLoading, lstItems);
    }

    private void init(int resLayout, int resLoading, List<T> lstItems) {
        this.mResLoading = resLoading;
        this.mResLayout = resLayout;
        this.mLstItems = lstItems;
    }

    public BaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 1 && this.mResLoading != -1) {
            View v = LayoutInflater.from((Context)parent.getContext()).inflate(this.mResLoading, parent, false);
            return new BaseViewHolder(v);
        }
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(this.mResLayout, parent, false);
        final BaseViewHolder baseViewHolder = new BaseViewHolder(v);
        if (this.mListener != null) {
            baseViewHolder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int position = baseViewHolder.getAdapterPosition();
                    AbstractBaseAdapter.this.mListener.onChildClick(v, AbstractBaseAdapter.this.mLstItems.get(position), position);
                }
            });
        }
        return baseViewHolder;
    }

    public void onBindViewHolder(BaseViewHolder holder, int position) {
        if (position >= this.getItemCount() - 1 && this.isMoreDataAvailable && !this.isLoading && this.mOnLoadMoreListener != null) {
            this.isLoading = true;
            this.mOnLoadMoreListener.onLoadMore();
        }
        if (this.getItemViewType(position) == 0) {
            this.bindItem(holder, this.getItem(position));
        } else if (this.getItemViewType(position) == 1 && this.mResLoading != -1) {
            this.bindError(holder, this.isLoadingError);
        }
    }

    public int getItemViewType(int position) {
        return position > this.mLstItems.size() - 1 ? 1 : 0;
    }

    public int getItemCount() {
        return this.isLoading && this.mResLoading != -1 ? this.mLstItems.size() + 1 : this.mLstItems.size();
    }

    public T getItem(int position) {
        return this.mLstItems.get(position);
    }

    protected abstract void bindItem(BaseViewHolder var1, T var2);

    protected abstract void bindError(BaseViewHolder var1, boolean var2);

    public OnLoadMoreListener getOnLoadMoreListener() {
        return this.mOnLoadMoreListener;
    }

    public void setOnChildClickListener(OnChildClickListener<T> listener) {
        this.mListener = listener;
    }

    public void setOnLoadMoreListener(OnLoadMoreListener onLoadMoreListener) {
        this.mOnLoadMoreListener = onLoadMoreListener;
    }

    public void addData(List<T> data) {
        if (data.isEmpty()) {
            this.isMoreDataAvailable = false;
        }
        this.mLstItems.addAll(data);
        this.notifyDataChanged();
    }

    public void clearData() {
        this.isMoreDataAvailable = true;
        this.isLoadingError = false;
        this.mLstItems.clear();
        this.notifyDataChanged();
    }

    private void notifyDataChanged() {
        this.notifyDataSetChanged();
        this.isLoading = false;
    }

    public void setLoadingError(boolean isError) {
        this.isLoadingError = isError;
        this.notifyDataSetChanged();
    }

    public static interface OnLoadMoreListener {
        public void onLoadMore();
    }

    public static interface OnChildClickListener<T> {
        public void onChildClick(View var1, T var2, int var3);
    }
}

