/*
 * Decompiled with CFR 0.152.
 */
package com.massivedisaster.adal.account;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AccountManagerCallback;
import android.accounts.AccountManagerFuture;
import android.content.Context;
import android.content.Intent;
import android.os.Build;

public class AccountHelper {
    private static AccountManager mManager;
    private static int deletedAccounts;

    public static void initialize(Context context) {
        mManager = AccountManager.get((Context)context);
    }

    public static void addAccount(final Context context, final String name, final String password, final String token) {
        AccountHelper.validateAccountManager();
        AccountHelper.clearAccounts(context, new OnAccountListener(){

            @Override
            public void onFinished() {
                Account account = new Account(name, context.getPackageName());
                Intent intent = new Intent();
                mManager.addAccountExplicitly(account, password, null);
                mManager.setAuthToken(account, context.getPackageName(), token);
                intent.putExtra("authAccount", name);
                intent.putExtra("accountType", context.getPackageName());
                intent.putExtra("authtoken", token);
            }
        });
    }

    public static synchronized void clearAccounts(Context context, final OnAccountListener onAccountListener) {
        AccountHelper.validateAccountManager();
        deletedAccounts = 0;
        final Account[] accounts = mManager.getAccountsByType(context.getPackageName());
        if (accounts.length == 0) {
            if (onAccountListener != null) {
                onAccountListener.onFinished();
            }
            return;
        }
        if (Build.VERSION.SDK_INT >= 22) {
            for (Account acc : accounts) {
                mManager.removeAccountExplicitly(acc);
            }
            if (onAccountListener != null) {
                onAccountListener.onFinished();
            }
        } else {
            for (Account account : accounts) {
                AccountManagerCallback<Boolean> callback = new AccountManagerCallback<Boolean>(){

                    public void run(AccountManagerFuture<Boolean> future) {
                        if (onAccountListener != null && ++deletedAccounts == accounts.length) {
                            onAccountListener.onFinished();
                        }
                    }
                };
                mManager.removeAccount(account, (AccountManagerCallback)callback, null);
            }
        }
    }

    public static boolean hasAccount(Context context) {
        AccountHelper.validateAccountManager();
        return mManager.getAccountsByType(context.getPackageName()).length > 0;
    }

    public static Account getCurrentAccount(Context context) {
        AccountHelper.validateAccountManager();
        return mManager.getAccountsByType(context.getPackageName())[0];
    }

    public static String getAccountPassword(Account account) {
        AccountHelper.validateAccountManager();
        return mManager.getPassword(account);
    }

    public static String getCurrentToken(Context context) {
        AccountHelper.validateAccountManager();
        Account account = mManager.getAccountsByType(context.getPackageName())[0];
        return mManager.peekAuthToken(account, context.getPackageName().trim());
    }

    private static void validateAccountManager() {
        if (mManager == null) {
            throw new NullPointerException("It's necessary to call AccountHelper.initialize first");
        }
    }

    public static interface OnAccountListener {
        public void onFinished();
    }
}

