/*
 * Decompiled with CFR 0.152.
 */
package com.massivedisaster.activitymanager;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.ActivityOptionsCompat;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.support.v4.util.Pair;
import android.view.View;
import com.massivedisaster.activitymanager.ITransaction;
import com.massivedisaster.activitymanager.activity.AbstractFragmentActivity;
import java.util.ArrayList;
import java.util.List;

public class ActivityTransaction
implements ITransaction<ActivityTransaction> {
    public static final String ACTIVITY_MANAGER_FRAGMENT = "activity_manager_fragment";
    public static final String ACTIVITY_MANAGER_FRAGMENT_TAG = "activity_manager_fragment_tag";
    public static final String ACTIVITY_MANAGER_FRAGMENT_SHARED_ELEMENTS = "activity_manager_fragment_shared_elements";
    private final Class<? extends AbstractFragmentActivity> mAbstractBaseActivity;
    private final Intent mIntent;
    private ActivityOptionsCompat mActivityOptions;
    private List<Pair<View, String>> mSharedElements;
    private Activity mActivityBase;
    private Fragment mFragment;
    private Context mContext;
    private Integer mRequestCode;

    ActivityTransaction(Activity activity, Class<? extends AbstractFragmentActivity> abstractBaseActivityClass, Class<? extends Fragment> fragmentClass) {
        this.mActivityBase = activity;
        this.mAbstractBaseActivity = abstractBaseActivityClass;
        this.mIntent = new Intent((Context)this.mActivityBase, this.mAbstractBaseActivity);
        this.mIntent.putExtra(ACTIVITY_MANAGER_FRAGMENT, fragmentClass.getCanonicalName());
    }

    ActivityTransaction(Fragment fragment, Class<? extends AbstractFragmentActivity> abstractBaseActivityClass, Class<? extends Fragment> fragmentClass) {
        this.mFragment = fragment;
        this.mAbstractBaseActivity = abstractBaseActivityClass;
        this.mIntent = new Intent(this.mFragment.getContext(), this.mAbstractBaseActivity);
        this.mIntent.putExtra(ACTIVITY_MANAGER_FRAGMENT, fragmentClass.getCanonicalName());
    }

    ActivityTransaction(Context context, Class<? extends AbstractFragmentActivity> abstractBaseActivityClass, Class<? extends Fragment> fragmentClass) {
        this.mContext = context;
        this.mAbstractBaseActivity = abstractBaseActivityClass;
        this.mIntent = new Intent(this.mContext, this.mAbstractBaseActivity);
        this.mIntent.putExtra(ACTIVITY_MANAGER_FRAGMENT, fragmentClass.getCanonicalName());
    }

    @Override
    public ActivityTransaction setTag(String tag) {
        this.mIntent.putExtra(ACTIVITY_MANAGER_FRAGMENT_TAG, tag);
        return this;
    }

    @Override
    public ActivityTransaction setBundle(Bundle bundle) {
        this.mIntent.putExtras(bundle);
        return this;
    }

    @Override
    public ActivityTransaction addSharedElement(View view, String transactionName) {
        this.mIntent.putExtra(ACTIVITY_MANAGER_FRAGMENT_SHARED_ELEMENTS, true);
        if (this.mSharedElements == null) {
            this.mSharedElements = new ArrayList<Pair<View, String>>();
        }
        this.mSharedElements.add((Pair<View, String>)new Pair((Object)view, (Object)transactionName));
        Pair[] sharedElements = this.mSharedElements.toArray(new Pair[this.mSharedElements.size()]);
        this.mActivityOptions = ActivityOptionsCompat.makeSceneTransitionAnimation((Activity)(this.mActivityBase == null ? this.mFragment.getActivity() : this.mActivityBase), (Pair[])sharedElements);
        return this;
    }

    public ActivityTransaction setRequestCode(int requestCode) {
        this.mRequestCode = requestCode;
        return this;
    }

    public ActivityOptionsCompat getActivityOptions() {
        return this.mActivityOptions;
    }

    public Intent getIntent() {
        return this.mIntent;
    }

    @Override
    public void commit() {
        Bundle bundleOptions;
        Intent intent = this.getIntent();
        Bundle bundle = bundleOptions = this.mActivityOptions != null ? this.mActivityOptions.toBundle() : null;
        if (this.mRequestCode == null) {
            if (this.mActivityBase != null) {
                ContextCompat.startActivity((Context)this.mActivityBase, (Intent)intent, (Bundle)bundleOptions);
            } else if (this.mFragment != null) {
                this.mFragment.startActivity(intent, bundleOptions);
            } else {
                this.mContext.startActivity(intent);
            }
        } else if (this.mActivityBase != null) {
            ActivityCompat.startActivityForResult((Activity)this.mActivityBase, (Intent)intent, (int)this.mRequestCode, (Bundle)bundleOptions);
        } else if (this.mFragment != null) {
            this.mFragment.startActivityForResult(intent, this.mRequestCode.intValue(), bundleOptions);
        } else {
            this.mContext.startActivity(intent);
        }
    }
}

