/*
 * Decompiled with CFR 0.152.
 */
package com.massivedisaster.activitymanager.activity;

import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.IdRes;
import android.support.annotation.LayoutRes;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import com.massivedisaster.activitymanager.ActivityFragmentManager;
import com.massivedisaster.activitymanager.OnBackPressedListener;
import com.massivedisaster.activitymanager.animation.TransactionAnimation;

public abstract class AbstractFragmentActivity
extends AppCompatActivity
implements TransactionAnimation {
    @LayoutRes
    public abstract int getLayoutResId();

    @IdRes
    public abstract int getContainerViewId();

    protected Class<? extends Fragment> getDefaultFragment() {
        Log.w((String)AbstractFragmentActivity.class.getCanonicalName(), (String)"No default fragment implemented!");
        return null;
    }

    public void onCreate(Bundle savedInstanceState) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.requestWindowFeature(13);
            this.requestWindowFeature(12);
        }
        super.onCreate(savedInstanceState);
        View rootView = LayoutInflater.from((Context)this).inflate(this.getLayoutResId(), null);
        this.setContentView(rootView);
        this.initializeDataBinding(rootView);
        if (this.getSupportFragmentManager().getBackStackEntryCount() == 0 && this.getIntent().hasExtra("activity_manager_fragment")) {
            this.performInitialTransaction(this.getFragment(this.getIntent().getStringExtra("activity_manager_fragment")), this.getFragmentTag());
        } else if (this.getDefaultFragment() != null) {
            this.performInitialTransaction(this.getFragment(this.getDefaultFragment().getCanonicalName()), null);
        }
    }

    protected void performInitialTransaction(Fragment fragment, String tag) {
        FragmentTransaction ft = this.getSupportFragmentManager().beginTransaction();
        ft.replace(this.getContainerViewId(), fragment, tag);
        ft.commitNow();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    private Fragment getFragment(String clazz) {
        try {
            Fragment f = (Fragment)Class.forName(clazz).newInstance();
            if (this.getIntent().getExtras() != null) {
                f.setArguments(this.getIntent().getExtras());
            }
            return f;
        }
        catch (ClassNotFoundException e) {
            Log.e((String)ActivityFragmentManager.class.getCanonicalName(), (String)e.toString());
        }
        catch (IllegalAccessException e) {
            Log.e((String)ActivityFragmentManager.class.getCanonicalName(), (String)e.toString());
        }
        catch (InstantiationException e) {
            Log.e((String)ActivityFragmentManager.class.getCanonicalName(), (String)e.toString());
        }
        return null;
    }

    protected void initializeDataBinding(View view) {
    }

    private String getFragmentTag() {
        return this.getIntent().getStringExtra("activity_manager_fragment_tag");
    }

    @Override
    public int getAnimationEnter() {
        return 0x10A0000;
    }

    @Override
    public int getAnimationExit() {
        return 0x10A0001;
    }

    @Override
    public int getAnimationPopEnter() {
        return 0x10A0000;
    }

    @Override
    public int getAnimationPopExit() {
        return 0x10A0001;
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
    }

    public void onBackPressed() {
        if (!this.canBackPress()) {
            super.onBackPressed();
        }
    }

    private boolean canBackPress() {
        Fragment activeFragment = this.getActiveFragment();
        return activeFragment != null && activeFragment instanceof OnBackPressedListener && ((OnBackPressedListener)activeFragment).onBackPressed();
    }

    private Fragment getActiveFragment() {
        return this.getSupportFragmentManager().findFragmentById(this.getContainerViewId());
    }
}

