/*
 * Decompiled with CFR 0.152.
 */
package com.massivedisaster.activitymanager;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.transition.TransitionInflater;
import android.util.Log;
import android.view.View;
import com.massivedisaster.activitymanager.ActivityFragmentManager;
import com.massivedisaster.activitymanager.ITransaction;
import com.massivedisaster.activitymanager.activity.AbstractFragmentActivity;
import com.massivedisaster.activitymanager.animation.TransactionAnimation;

public abstract class FragmentTransaction
implements ITransaction<FragmentTransaction> {
    protected AbstractFragmentActivity mActivity;
    protected Fragment mFragment;
    protected android.support.v4.app.FragmentTransaction mFrgTransaction;
    protected String mTag;

    @SuppressLint(value={"CommitTransaction"})
    FragmentTransaction(AbstractFragmentActivity activity, Class<? extends Fragment> fragmentClass) {
        this.mActivity = activity;
        this.mFrgTransaction = this.mActivity.getSupportFragmentManager().beginTransaction();
        try {
            this.mFragment = fragmentClass.newInstance();
            if (Build.VERSION.SDK_INT >= 21) {
                this.mFragment.setSharedElementEnterTransition((Object)TransitionInflater.from((Context)this.mActivity).inflateTransition(0x10F0001));
                this.mFragment.setSharedElementReturnTransition((Object)TransitionInflater.from((Context)this.mActivity).inflateTransition(0x10F0001));
            }
        }
        catch (InstantiationException e) {
            Log.e((String)ActivityFragmentManager.class.getCanonicalName(), (String)e.toString());
        }
        catch (IllegalAccessException e) {
            Log.e((String)ActivityFragmentManager.class.getCanonicalName(), (String)e.toString());
        }
    }

    @Override
    public FragmentTransaction setTag(String tag) {
        this.mTag = tag;
        return this;
    }

    @Override
    public FragmentTransaction setBundle(Bundle bundle) {
        if (bundle != null) {
            this.mFragment.setArguments(bundle);
        }
        return this;
    }

    @Override
    public FragmentTransaction addSharedElement(View view, String transactionName) {
        this.mFrgTransaction.addSharedElement(view, transactionName);
        return this;
    }

    public FragmentTransaction addToBackStack(String name) {
        this.mFrgTransaction.addToBackStack(name);
        return this;
    }

    public android.support.v4.app.FragmentTransaction getFragmentTransaction() {
        return this.mFrgTransaction;
    }

    public Fragment getFragment() {
        return this.mFragment;
    }

    public FragmentTransaction setTransactionAnimation(TransactionAnimation transactionAnimation) {
        if (transactionAnimation == null) {
            transactionAnimation = this.mActivity;
        }
        this.mFrgTransaction.setCustomAnimations(transactionAnimation.getAnimationEnter(), transactionAnimation.getAnimationExit(), transactionAnimation.getAnimationPopEnter(), transactionAnimation.getAnimationPopExit());
        return this;
    }
}

