/*
 * Decompiled with CFR 0.152.
 */
package com.massivedisaster.activitymanager.lint;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.BinaryExpression;
import lombok.ast.BinaryOperator;
import lombok.ast.ConstructorInvocation;
import lombok.ast.Expression;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.Return;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.VariableReference;

public class CommitTransaction
extends Detector
implements Detector.JavaScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(CommitTransaction.class, Scope.JAVA_FILE_SCOPE);
    static final Issue COMMIT_FRAGMENT = Issue.create((String)"CommitTransaction", (String)"Missing `commit()` calls", (String)"After creating a `Transaction`, you typically need to commit it as well", (Category)Category.CORRECTNESS, (int)7, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    private static final String ADD_TRANSACTION = "add";
    private static final String OPEN_TRANSACTION = "open";
    private static final String REPLACE_TRANSACTION = "replace";
    private static final String COMMIT = "commit";
    private static final String GET_INTENT = "getIntent";
    private static final String ACTIVITY_MANAGER = "com.massivedisaster.activitymanager.ActivityFragmentManager";

    private static boolean checkTransactionHasACommit(@NonNull JavaContext context, @NonNull MethodInvocation node) {
        return !CommitTransaction.isAddReplaceOpen(context, node) || CommitTransaction.isCommittedInChainedCalls(context, node);
    }

    private static boolean isAddReplaceOpen(@NonNull JavaContext context, @NonNull MethodInvocation node) {
        JavaParser.ResolvedMethod method;
        JavaParser.ResolvedClass containingClass;
        JavaParser.ResolvedNode resolved;
        String methodName = node.astName().astValue();
        return (ADD_TRANSACTION.equals(methodName) || OPEN_TRANSACTION.equals(methodName) || REPLACE_TRANSACTION.equals(methodName)) && (resolved = context.resolve((Node)node)) instanceof JavaParser.ResolvedMethod && (containingClass = (method = (JavaParser.ResolvedMethod)resolved).getContainingClass()).isSubclassOf(ACTIVITY_MANAGER, false);
    }

    private static boolean isCommittedInChainedCalls(@NonNull JavaContext context, @NonNull MethodInvocation node) {
        JavaParser.ResolvedVariable boundVariable = CommitTransaction.getVariable(context, (Node)node);
        if (boundVariable == null) {
            Node parent = node.getParent();
            while (parent instanceof MethodInvocation) {
                MethodInvocation methodInvocation = (MethodInvocation)parent;
                if (CommitTransaction.isTransactionCommitMethodCall(methodInvocation)) {
                    return true;
                }
                parent = parent.getParent();
            }
        }
        if (boundVariable != null) {
            Node method = JavaContext.findSurroundingMethod((Node)node);
            if (method == null) {
                return true;
            }
            FinishVisitor commitVisitor = new FinishVisitor(context, boundVariable){

                @Override
                protected boolean isCleanupCall(@NonNull MethodInvocation call) {
                    Expression operand;
                    if (CommitTransaction.isTransactionCommitMethodCall(call) && (operand = call.astOperand()) != null) {
                        JavaParser.ResolvedNode resolved = this.mContext.resolve((Node)operand);
                        if (resolved != null && this.mVariables.contains(resolved)) {
                            return true;
                        }
                        if (resolved instanceof JavaParser.ResolvedMethod && operand instanceof MethodInvocation && CommitTransaction.isCommittedInChainedCalls(this.mContext, (MethodInvocation)operand)) {
                            while (operand instanceof MethodInvocation) {
                                operand = ((MethodInvocation)operand).astOperand();
                            }
                            if (operand instanceof VariableReference && (resolved = this.mContext.resolve((Node)operand)) != null && this.mVariables.contains(resolved)) {
                                return true;
                            }
                        }
                    }
                    return false;
                }
            };
            method.accept((AstVisitor)commitVisitor);
            if (commitVisitor.isCleanedUp()) {
                return true;
            }
        }
        return false;
    }

    private static boolean isTransactionCommitMethodCall(@NonNull MethodInvocation call) {
        String methodName = call.astName().astValue();
        return COMMIT.equals(methodName) || GET_INTENT.equals(methodName);
    }

    @Nullable
    private static JavaParser.ResolvedVariable getVariable(@NonNull JavaContext context, @NonNull Node expression) {
        JavaParser.ResolvedNode resolved;
        Node parent = expression.getParent();
        if (parent instanceof BinaryExpression) {
            Expression lhs;
            JavaParser.ResolvedNode resolved2;
            BinaryExpression binaryExpression = (BinaryExpression)parent;
            if (binaryExpression.astOperator() == BinaryOperator.ASSIGN && (resolved2 = context.resolve((Node)(lhs = binaryExpression.astLeft()))) instanceof JavaParser.ResolvedVariable) {
                return (JavaParser.ResolvedVariable)resolved2;
            }
        } else if (parent instanceof VariableDefinitionEntry && (resolved = context.resolve(parent)) instanceof JavaParser.ResolvedVariable) {
            return (JavaParser.ResolvedVariable)resolved;
        }
        return null;
    }

    private static void showCommitMessage(JavaContext context, Node node) {
        String message = "This transaction should be completed with a `commit()` call.";
        context.report(COMMIT_FRAGMENT, node, context.getLocation(node), message);
    }

    @Nullable
    public List<String> getApplicableMethodNames() {
        return Arrays.asList(ADD_TRANSACTION, OPEN_TRANSACTION, REPLACE_TRANSACTION);
    }

    public void visitMethod(@NonNull JavaContext context, @Nullable AstVisitor visitor, @NonNull MethodInvocation node) {
        if (!CommitTransaction.checkTransactionHasACommit(context, node)) {
            CommitTransaction.showCommitMessage(context, (Node)node);
        }
    }

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    public AstVisitor createJavaVisitor(@NonNull JavaContext context) {
        return new CallChecker(context);
    }

    private static abstract class FinishVisitor
    extends ForwardingAstVisitor {
        final JavaContext mContext;
        final List<JavaParser.ResolvedVariable> mVariables;
        private boolean mContainsCleanup;

        FinishVisitor(JavaContext context, @NonNull JavaParser.ResolvedVariable variable) {
            this.mContext = context;
            this.mVariables = Lists.newArrayList((Object[])new JavaParser.ResolvedVariable[]{variable});
        }

        boolean isCleanedUp() {
            return this.mContainsCleanup;
        }

        public boolean visitNode(Node node) {
            return this.mContainsCleanup || super.visitNode(node);
        }

        protected abstract boolean isCleanupCall(@NonNull MethodInvocation var1);

        public boolean visitMethodInvocation(MethodInvocation call) {
            if (this.mContainsCleanup) {
                return true;
            }
            super.visitMethodInvocation(call);
            if (this.isCleanupCall(call)) {
                this.mContainsCleanup = true;
                return true;
            }
            return false;
        }

        public boolean visitVariableDefinitionEntry(VariableDefinitionEntry node) {
            JavaParser.ResolvedNode resolvedVariable;
            JavaParser.ResolvedNode resolved;
            Expression initializer = node.astInitializer();
            if (initializer instanceof VariableReference && (resolved = this.mContext.resolve((Node)initializer)) != null && this.mVariables.contains(resolved) && (resolvedVariable = this.mContext.resolve((Node)node)) instanceof JavaParser.ResolvedVariable) {
                JavaParser.ResolvedVariable variable = (JavaParser.ResolvedVariable)resolvedVariable;
                this.mVariables.add(variable);
            }
            return super.visitVariableDefinitionEntry(node);
        }

        public boolean visitBinaryExpression(BinaryExpression node) {
            JavaParser.ResolvedNode resolvedLhs;
            JavaParser.ResolvedNode resolved;
            Expression rhs;
            if (node.astOperator() == BinaryOperator.ASSIGN && (rhs = node.astRight()) instanceof VariableReference && (resolved = this.mContext.resolve((Node)rhs)) != null && this.mVariables.contains(resolved) && (resolvedLhs = this.mContext.resolve((Node)node.astLeft())) instanceof JavaParser.ResolvedVariable) {
                JavaParser.ResolvedVariable variable = (JavaParser.ResolvedVariable)resolvedLhs;
                this.mVariables.add(variable);
            }
            return super.visitBinaryExpression(node);
        }

        public boolean visitReturn(Return node) {
            return super.visitReturn(node);
        }
    }

    private static class CallChecker
    extends ForwardingAstVisitor {
        private final JavaContext mContext;

        CallChecker(JavaContext context) {
            this.mContext = context;
        }

        public boolean visitMethodInvocation(@NonNull MethodInvocation call) {
            JavaParser.ResolvedNode resolved = this.mContext.resolve((Node)call);
            if (resolved instanceof JavaParser.ResolvedMethod && !CommitTransaction.checkTransactionHasACommit(this.mContext, call)) {
                CommitTransaction.showCommitMessage(this.mContext, (Node)call);
            }
            return false;
        }

        public boolean visitConstructorInvocation(@NonNull ConstructorInvocation call) {
            return false;
        }
    }
}

