/*
 * Decompiled with CFR 0.152.
 */
package com.massivedisaster.activitymanager;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.util.Log;
import com.massivedisaster.activitymanager.AbstractFragmentActivity;
import com.massivedisaster.activitymanager.LinkedMethod;
import com.massivedisaster.activitymanager.TransactionAnimation;

public final class ActivityFragmentManager {
    public static final String ACTIVITY_MANAGER_FRAGMENT = "activity_manager_fragment";
    public static final String ACTIVITY_MANAGER_FRAGMENT_TAG = "activity_manager_fragment_tag";

    private ActivityFragmentManager() {
    }

    public static void open(Activity activity, Class<? extends AbstractFragmentActivity> activityClazz, Class<? extends Fragment> fragmentClazz, String tag, Bundle bundle, Integer requestCode) {
        Intent intent = new Intent((Context)activity, activityClazz);
        intent.putExtra(ACTIVITY_MANAGER_FRAGMENT, fragmentClazz.getCanonicalName());
        intent.putExtra(ACTIVITY_MANAGER_FRAGMENT_TAG, tag);
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        if (requestCode == null) {
            activity.startActivity(intent);
        } else {
            activity.startActivityForResult(intent, requestCode.intValue());
        }
    }

    @LinkedMethod
    public static void open(Activity activity, Class<? extends AbstractFragmentActivity> activityClazz, Class<? extends Fragment> fragmentClazz, Bundle bundle, Integer requestCode) {
        ActivityFragmentManager.open(activity, activityClazz, fragmentClazz, null, bundle, requestCode);
    }

    @LinkedMethod
    public static void open(Activity activity, Class<? extends AbstractFragmentActivity> activityClazz, Class<? extends Fragment> fragmentClazz, String tag, Bundle bundle) {
        ActivityFragmentManager.open(activity, activityClazz, fragmentClazz, tag, bundle, null);
    }

    @LinkedMethod
    public static void open(Activity activity, Class<? extends AbstractFragmentActivity> activityClazz, Class<? extends Fragment> fragmentClazz, String tag) {
        ActivityFragmentManager.open(activity, activityClazz, fragmentClazz, tag, null, null);
    }

    @LinkedMethod
    public static void open(Activity activity, Class<? extends AbstractFragmentActivity> activityClazz, Class<? extends Fragment> fragmentClazz, String tag, Integer requestCode) {
        ActivityFragmentManager.open(activity, activityClazz, fragmentClazz, tag, null, requestCode);
    }

    @LinkedMethod
    public static void open(Activity activity, Class<? extends AbstractFragmentActivity> activityClazz, Class<? extends Fragment> fragmentClazz, Bundle bundle) {
        ActivityFragmentManager.open(activity, activityClazz, fragmentClazz, null, bundle, null);
    }

    @LinkedMethod
    public static void open(Activity activity, Class<? extends AbstractFragmentActivity> activityClazz, Class<? extends Fragment> fragmentClazz) {
        ActivityFragmentManager.open(activity, activityClazz, fragmentClazz, null, null, null);
    }

    @LinkedMethod
    public static void open(Activity activity, Class<? extends AbstractFragmentActivity> activityClazz, Class<? extends Fragment> fragmentClazz, Integer requestCode) {
        ActivityFragmentManager.open(activity, activityClazz, fragmentClazz, null, null, requestCode);
    }

    @LinkedMethod
    public static void open(Fragment fragment, Class<? extends AbstractFragmentActivity> activityClazz, Class<? extends Fragment> fragmentClazz, String tag, Bundle bundle, Integer requestCode) {
        Intent intent = new Intent(fragment.getContext(), activityClazz);
        intent.putExtra(ACTIVITY_MANAGER_FRAGMENT, fragmentClazz.getCanonicalName());
        intent.putExtra(ACTIVITY_MANAGER_FRAGMENT_TAG, tag);
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        if (requestCode == null) {
            fragment.startActivity(intent);
        } else {
            fragment.startActivityForResult(intent, requestCode.intValue());
        }
    }

    @LinkedMethod
    public static void open(Fragment fragment, Class<? extends AbstractFragmentActivity> activityClazz, Class<? extends Fragment> fragmentClazz, Bundle bundle, Integer requestCode) {
        ActivityFragmentManager.open(fragment, activityClazz, fragmentClazz, null, bundle, requestCode);
    }

    @LinkedMethod
    public static void open(Fragment fragment, Class<? extends AbstractFragmentActivity> activityClazz, Class<? extends Fragment> fragmentClazz, String tag, Integer requestCode) {
        ActivityFragmentManager.open(fragment, activityClazz, fragmentClazz, tag, null, requestCode);
    }

    @LinkedMethod
    public static void open(Fragment fragment, Class<? extends AbstractFragmentActivity> activityClazz, Class<? extends Fragment> fragmentClazz, Integer requestCode) {
        ActivityFragmentManager.open(fragment, activityClazz, fragmentClazz, null, null, requestCode);
    }

    public static void add(AbstractFragmentActivity activity, Class<? extends Fragment> fragmentClazz, String tag, Bundle bundle, TransactionAnimation animation) {
        FragmentTransaction transaction = activity.getSupportFragmentManager().beginTransaction();
        try {
            Fragment f = fragmentClazz.newInstance();
            if (bundle != null) {
                f.setArguments(bundle);
            }
            transaction.addToBackStack(null);
            if (animation == null) {
                animation = activity;
            }
            transaction.setCustomAnimations(animation.getAnimationEnter(), animation.getAnimationExit(), animation.getAnimationPopEnter(), animation.getAnimationPopExit());
            if (activity.getSupportFragmentManager().findFragmentById(activity.getContainerViewId()) != null) {
                transaction.hide(activity.getSupportFragmentManager().findFragmentById(activity.getContainerViewId()));
            }
            transaction.add(activity.getContainerViewId(), f, tag);
            transaction.commit();
        }
        catch (InstantiationException e) {
            Log.e((String)ActivityFragmentManager.class.getCanonicalName(), (String)e.toString());
        }
        catch (IllegalAccessException e) {
            Log.e((String)ActivityFragmentManager.class.getCanonicalName(), (String)e.toString());
        }
    }

    @LinkedMethod
    public static void add(AbstractFragmentActivity activity, Class<? extends Fragment> fragmentClazz, Bundle bundle, TransactionAnimation animation) {
        ActivityFragmentManager.add(activity, fragmentClazz, null, bundle, animation);
    }

    @LinkedMethod
    public static void add(AbstractFragmentActivity activity, Class<? extends Fragment> fragmentClazz, String tag, TransactionAnimation animation) {
        ActivityFragmentManager.add(activity, fragmentClazz, tag, null, animation);
    }

    @LinkedMethod
    public static void add(AbstractFragmentActivity activity, Class<? extends Fragment> fragmentClazz, String tag, Bundle bundle) {
        ActivityFragmentManager.add(activity, fragmentClazz, tag, bundle, null);
    }

    @LinkedMethod
    public static void add(AbstractFragmentActivity activity, Class<? extends Fragment> fragmentClazz, TransactionAnimation animation) {
        ActivityFragmentManager.add(activity, fragmentClazz, null, null, animation);
    }

    @LinkedMethod
    public static void add(AbstractFragmentActivity activity, Class<? extends Fragment> fragmentClazz, Bundle bundle) {
        ActivityFragmentManager.add(activity, fragmentClazz, null, bundle, null);
    }

    @LinkedMethod
    public static void add(AbstractFragmentActivity activity, Class<? extends Fragment> fragmentClazz, String tag) {
        ActivityFragmentManager.add(activity, fragmentClazz, tag, null, null);
    }

    @LinkedMethod
    public static void add(AbstractFragmentActivity activity, Class<? extends Fragment> fragmentClazz) {
        ActivityFragmentManager.add(activity, fragmentClazz, null, null, null);
    }

    public static void replace(AbstractFragmentActivity activity, Class<? extends Fragment> fragmentClazz, Bundle bundle, TransactionAnimation animation) {
        FragmentTransaction transaction = activity.getSupportFragmentManager().beginTransaction();
        try {
            Fragment f = fragmentClazz.newInstance();
            if (bundle != null) {
                f.setArguments(bundle);
            }
            if (animation == null) {
                animation = activity;
            }
            transaction.setCustomAnimations(animation.getAnimationEnter(), animation.getAnimationExit(), animation.getAnimationPopEnter(), animation.getAnimationPopExit());
            transaction.replace(activity.getContainerViewId(), f);
            transaction.addToBackStack(null);
            transaction.commit();
        }
        catch (InstantiationException e) {
            Log.e((String)ActivityFragmentManager.class.getCanonicalName(), (String)e.toString());
        }
        catch (IllegalAccessException e) {
            Log.e((String)ActivityFragmentManager.class.getCanonicalName(), (String)e.toString());
        }
    }

    @LinkedMethod
    public static void replace(AbstractFragmentActivity activity, Class<? extends Fragment> fragmentClazz, Bundle bundle) {
        ActivityFragmentManager.replace(activity, fragmentClazz, bundle, null);
    }

    @LinkedMethod
    public static void replace(AbstractFragmentActivity activity, Class<? extends Fragment> fragmentClazz) {
        ActivityFragmentManager.replace(activity, fragmentClazz, null, null);
    }

    @LinkedMethod
    public static void replace(AbstractFragmentActivity activity, Class<? extends Fragment> fragmentClazz, TransactionAnimation animation) {
        ActivityFragmentManager.replace(activity, fragmentClazz, null, animation);
    }

    public static Intent getIntent(Context context, Class<? extends AbstractFragmentActivity> activityClazz, Class<? extends Fragment> fragmentClazz, String tag, Bundle bundle) {
        Intent intent = new Intent(context, activityClazz);
        intent.putExtra(ACTIVITY_MANAGER_FRAGMENT, fragmentClazz.getCanonicalName());
        intent.putExtra(ACTIVITY_MANAGER_FRAGMENT_TAG, tag);
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        return intent;
    }

    @LinkedMethod
    public static Intent getIntent(Context context, Class<? extends AbstractFragmentActivity> activityClazz, Class<? extends Fragment> fragmentClazz) {
        return ActivityFragmentManager.getIntent(context, activityClazz, fragmentClazz, null, null);
    }

    @LinkedMethod
    public static Intent getIntent(Context context, Class<? extends AbstractFragmentActivity> activityClazz, Class<? extends Fragment> fragmentClazz, String tag) {
        return ActivityFragmentManager.getIntent(context, activityClazz, fragmentClazz, tag, null);
    }

    @LinkedMethod
    public static Intent getIntent(Context context, Class<? extends AbstractFragmentActivity> activityClazz, Class<? extends Fragment> fragmentClazz, Bundle bundle) {
        return ActivityFragmentManager.getIntent(context, activityClazz, fragmentClazz, null, bundle);
    }
}

