/*
 * Decompiled with CFR 0.152.
 */
package com.massivedisaster.activitymanager;

import android.content.res.Configuration;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import com.massivedisaster.activitymanager.ActivityFragmentManager;
import com.massivedisaster.activitymanager.TransactionAnimation;

public abstract class AbstractFragmentActivity
extends AppCompatActivity
implements TransactionAnimation {
    protected abstract int getLayoutResId();

    protected abstract int getContainerViewId();

    protected Class<? extends Fragment> getDefaultFragment() {
        Log.w((String)AbstractFragmentActivity.class.getCanonicalName(), (String)"No default fragment implemented!");
        return null;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(this.getLayoutResId());
    }

    protected void onStart() {
        super.onStart();
        if (this.getSupportFragmentManager().getBackStackEntryCount() == 0 && this.getIntent().hasExtra("activity_manager_fragment")) {
            this.performInitialTransaction(this.getFragment(this.getIntent().getStringExtra("activity_manager_fragment")), this.getFragmentTag());
        } else if (this.getDefaultFragment() != null) {
            this.performInitialTransaction(this.getFragment(this.getDefaultFragment().getCanonicalName()), null);
        }
    }

    protected void performInitialTransaction(Fragment fragment, String tag) {
        FragmentTransaction ft = this.getSupportFragmentManager().beginTransaction();
        ft.replace(this.getContainerViewId(), fragment, tag);
        ft.addToBackStack(tag);
        ft.commitAllowingStateLoss();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    private Fragment getFragment(String clazz) {
        try {
            Fragment f = (Fragment)Class.forName(clazz).newInstance();
            if (this.getIntent().getExtras() != null) {
                f.setArguments(this.getIntent().getExtras());
            }
            return f;
        }
        catch (ClassNotFoundException e) {
            Log.e((String)ActivityFragmentManager.class.getCanonicalName(), (String)e.toString());
        }
        catch (IllegalAccessException e) {
            Log.e((String)ActivityFragmentManager.class.getCanonicalName(), (String)e.toString());
        }
        catch (InstantiationException e) {
            Log.e((String)ActivityFragmentManager.class.getCanonicalName(), (String)e.toString());
        }
        return null;
    }

    private String getFragmentTag() {
        return this.getIntent().getStringExtra("activity_manager_fragment_tag");
    }

    public void onBackPressed() {
        if (this.getSupportFragmentManager().getBackStackEntryCount() == 1) {
            this.finish();
        } else {
            super.onBackPressed();
        }
    }

    @Override
    public int getAnimationEnter() {
        return 0x10A0000;
    }

    @Override
    public int getAnimationExit() {
        return 0x10A0001;
    }

    @Override
    public int getAnimationPopEnter() {
        return 0x10A0000;
    }

    @Override
    public int getAnimationPopExit() {
        return 0x10A0001;
    }
}

