/*
 * Decompiled with CFR 0.152.
 */
package com.massivedisaster.activitymanager;

import android.content.res.Configuration;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import com.massivedisaster.activitymanager.ActivityFragmentManager;

public abstract class AbstractFragmentActivity
extends AppCompatActivity {
    protected abstract int getLayoutResId();

    protected abstract int getContainerViewId();

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(this.getLayoutResId());
    }

    protected void onStart() {
        super.onStart();
        if (this.getSupportFragmentManager().getBackStackEntryCount() == 0 && this.getIntent().hasExtra("activity_manager_fragment")) {
            this.performTransaction(this.getFragment(), this.getFragmentTag());
        }
    }

    protected void performTransaction(Fragment fragment, String tag) {
        FragmentTransaction ft = this.getSupportFragmentManager().beginTransaction();
        ft.replace(this.getContainerViewId(), fragment, tag);
        ft.addToBackStack(tag);
        ft.commitAllowingStateLoss();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    private Fragment getFragment() {
        try {
            Fragment f = (Fragment)Class.forName(this.getIntent().getStringExtra("activity_manager_fragment")).newInstance();
            if (this.getIntent().getExtras() != null) {
                f.setArguments(this.getIntent().getExtras());
            }
            return f;
        }
        catch (ClassNotFoundException e) {
            Log.e((String)ActivityFragmentManager.class.getCanonicalName(), (String)e.toString());
        }
        catch (IllegalAccessException e) {
            Log.e((String)ActivityFragmentManager.class.getCanonicalName(), (String)e.toString());
        }
        catch (InstantiationException e) {
            Log.e((String)ActivityFragmentManager.class.getCanonicalName(), (String)e.toString());
        }
        return null;
    }

    private String getFragmentTag() {
        return this.getIntent().getStringExtra("activity_manager_fragment_tag");
    }

    protected int getAnimFragmentEnter() {
        return 0x10A0000;
    }

    protected int getAnimFragmentExit() {
        return 0x10A0001;
    }

    protected int getAnimFragmentPopEnter() {
        return 0x10A0000;
    }

    protected int getAnimFragmentPopExit() {
        return 0x10A0001;
    }

    public void onBackPressed() {
        if (this.getSupportFragmentManager().getBackStackEntryCount() == 1) {
            this.finish();
        } else {
            super.onBackPressed();
        }
    }
}

