/*
 * Decompiled with CFR 0.152.
 */
package com.mashape.unirest.request;

import com.mashape.unirest.http.HttpMethod;
import com.mashape.unirest.http.utils.Base64Coder;
import com.mashape.unirest.request.BaseRequest;
import com.mashape.unirest.request.body.Body;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequest
extends BaseRequest {
    private HttpMethod httpMethod;
    protected String url;
    private Map<String, String> headers = new HashMap<String, String>();
    protected Body body;

    private URL parseUrl(String s) throws Exception {
        return new URI(s.replaceAll("\\s+", "%20")).toURL();
    }

    public HttpRequest(HttpMethod method, String url) {
        this.httpMethod = method;
        try {
            this.url = this.parseUrl(url).toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.httpRequest = this;
    }

    public HttpRequest basicAuth(String username, String password) {
        this.header("Authorization", "Basic " + Base64Coder.encodeString(username + ":" + password));
        return this;
    }

    public HttpRequest header(String name, String value) {
        this.headers.put(name.toLowerCase(), value);
        return this;
    }

    public HttpRequest headers(Map<String, String> headers) {
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                this.header(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, String> getHeaders() {
        if (this.headers == null) {
            return new HashMap<String, String>();
        }
        return this.headers;
    }

    public Body getBody() {
        return this.body;
    }
}

