/*
 * Decompiled with CFR 0.152.
 */
package com.marvelution.jira.plugins.hudson.xstream;

import com.marvelution.jira.plugins.hudson.model.ApiImplementation;
import com.marvelution.jira.plugins.hudson.model.Build;
import com.marvelution.jira.plugins.hudson.model.BuildArtifact;
import com.marvelution.jira.plugins.hudson.model.BuildsList;
import com.marvelution.jira.plugins.hudson.model.HealthReport;
import com.marvelution.jira.plugins.hudson.model.HudsonView;
import com.marvelution.jira.plugins.hudson.model.HudsonViewsList;
import com.marvelution.jira.plugins.hudson.model.Job;
import com.marvelution.jira.plugins.hudson.model.JobsList;
import com.marvelution.jira.plugins.hudson.model.TestResult;
import com.marvelution.jira.plugins.hudson.model.triggers.LegacyCodeTrigger;
import com.marvelution.jira.plugins.hudson.model.triggers.ProjectTrigger;
import com.marvelution.jira.plugins.hudson.model.triggers.RemoteTrigger;
import com.marvelution.jira.plugins.hudson.model.triggers.SCMTrigger;
import com.marvelution.jira.plugins.hudson.model.triggers.TimeTrigger;
import com.marvelution.jira.plugins.hudson.model.triggers.UserTrigger;
import com.marvelution.jira.plugins.hudson.xstream.XStreamMarshallerException;
import com.thoughtworks.xstream.XStream;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XStreamMarshaller {
    private static final Logger LOGGER = Logger.getLogger(XStreamMarshaller.class);
    private static XStream xstream = new XStream();

    public static <T> String marshal(T source) throws XStreamMarshallerException {
        if (source == null) {
            return "";
        }
        try {
            XStream.class.getMethod("autodetectAnnotations", Boolean.TYPE);
            return xstream.toXML(source);
        }
        catch (Exception e) {
            LOGGER.debug((Object)("Cannot use Automatic Annotation Detecting XStream. Reason: " + e.getMessage()), (Throwable)e);
            throw new XStreamMarshallerException("Cannot get XStream object for marshalling", e);
        }
    }

    public static <T> T unmarshal(String xml, Class<T> clazz) throws XStreamMarshallerException {
        if ("".equals(xml)) {
            return null;
        }
        try {
            XStream.class.getMethod("autodetectAnnotations", Boolean.TYPE);
            return clazz.cast(xstream.fromXML(xml));
        }
        catch (Exception e) {
            LOGGER.debug((Object)("Cannot use Automatic Annotation Detecting XStream. Reason: " + e.getMessage()), (Throwable)e);
            throw new XStreamMarshallerException("Cannot get XStream object for marshalling", e);
        }
    }

    static {
        xstream.autodetectAnnotations(true);
        xstream.processAnnotations(ApiImplementation.class);
        xstream.processAnnotations(JobsList.class);
        xstream.processAnnotations(Job.class);
        xstream.processAnnotations(BuildsList.class);
        xstream.processAnnotations(Build.class);
        xstream.processAnnotations(HealthReport.class);
        xstream.processAnnotations(TestResult.class);
        xstream.processAnnotations(UserTrigger.class);
        xstream.processAnnotations(RemoteTrigger.class);
        xstream.processAnnotations(ProjectTrigger.class);
        xstream.processAnnotations(LegacyCodeTrigger.class);
        xstream.processAnnotations(SCMTrigger.class);
        xstream.processAnnotations(TimeTrigger.class);
        xstream.processAnnotations(HudsonView.class);
        xstream.processAnnotations(HudsonViewsList.class);
        xstream.processAnnotations(BuildArtifact.class);
    }
}

