/*
 * Decompiled with CFR 0.152.
 */
package com.marvelution.jira.plugins.hudson.model;

import com.marvelution.jira.plugins.hudson.model.Build;
import com.marvelution.jira.plugins.hudson.model.BuildsList;
import com.marvelution.jira.plugins.hudson.model.HealthReport;
import com.marvelution.jira.plugins.hudson.model.HudsonServerAware;
import com.marvelution.jira.plugins.hudson.model.JobsList;
import com.marvelution.jira.plugins.hudson.model.Result;
import com.marvelution.jira.plugins.hudson.xstream.converters.ResultConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="job")
public class Job
implements HudsonServerAware,
Comparable<Job> {
    @XStreamOmitField
    private int hudsonServerId;
    private String jiraKey;
    private String name;
    private String url;
    private String description;
    private boolean buildable;
    private BuildsList builds;
    private Build firstBuild;
    private Build lastBuild;
    private Build lastCompletedBuild;
    private Build lastFailedBuild;
    private Build lastStableBuild;
    private Build lastUnstableBuild;
    private Build lastSuccessfulBuild;
    private int nextBuildNumber;
    @XStreamImplicit(itemFieldName="healthReport")
    private List<HealthReport> healthReports;
    @XStreamConverter(value=ResultConverter.class)
    @XStreamAlias(value="result")
    private Result result;
    @XStreamAlias(value="modules")
    private JobsList modules;

    public Job(String name, String description) {
        this.setName(name);
        this.setDescription(description);
    }

    @Override
    public int getHudsonServerId() {
        return this.hudsonServerId;
    }

    @Override
    public void setHudsonServerId(int hudsonServerId) {
        this.hudsonServerId = hudsonServerId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getJiraKey() {
        return this.jiraKey;
    }

    public void setJiraKey(String jiraKey) {
        this.jiraKey = jiraKey;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isBuildable() {
        return this.buildable;
    }

    public void setBuildable(boolean buildable) {
        this.buildable = buildable;
    }

    public List<Build> getBuilds() {
        if (this.builds == null) {
            this.builds = new BuildsList();
        }
        return this.builds.getBuilds();
    }

    public void setBuilds(List<Build> builds) {
        if (this.builds == null) {
            this.builds = new BuildsList();
        }
        this.builds.getBuilds().addAll(builds);
    }

    public void setBuildsList(BuildsList buildsList) {
        this.builds = buildsList;
    }

    public Build getFirstBuild() {
        return this.firstBuild;
    }

    public void setFirstBuild(Build firstBuild) {
        this.firstBuild = firstBuild;
    }

    public Build getLastBuild() {
        return this.lastBuild;
    }

    public void setLastBuild(Build lastBuild) {
        this.lastBuild = lastBuild;
    }

    public Build getLastCompletedBuild() {
        return this.lastCompletedBuild;
    }

    public void setLastCompletedBuild(Build lastCompletedBuild) {
        this.lastCompletedBuild = lastCompletedBuild;
    }

    public Build getLastFailedBuild() {
        return this.lastFailedBuild;
    }

    public void setLastFailedBuild(Build lastFailedBuild) {
        this.lastFailedBuild = lastFailedBuild;
    }

    public Build getLastStableBuild() {
        return this.lastStableBuild;
    }

    public void setLastStableBuild(Build lastStableBuild) {
        this.lastStableBuild = lastStableBuild;
    }

    public Build getLastUnstableBuild() {
        return this.lastUnstableBuild;
    }

    public void setLastUnstableBuild(Build lastUnstableBuild) {
        this.lastUnstableBuild = lastUnstableBuild;
    }

    public Build getLastSuccessfulBuild() {
        return this.lastSuccessfulBuild;
    }

    public void setLastSuccessfulBuild(Build lastSuccessfulBuild) {
        this.lastSuccessfulBuild = lastSuccessfulBuild;
    }

    public int getNextBuildNumber() {
        return this.nextBuildNumber;
    }

    public void setNextBuildNumber(int nextBuildNumber) {
        this.nextBuildNumber = nextBuildNumber;
    }

    public List<HealthReport> getHealthReports() {
        return this.healthReports;
    }

    public void setHealthReports(List<HealthReport> healthReports) {
        this.healthReports = healthReports;
        Collections.sort(this.healthReports);
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public List<Job> getModules() {
        if (this.modules == null) {
            this.modules = new JobsList();
        }
        return this.modules.getJobs();
    }

    public void setModules(List<Job> modules) {
        if (this.modules == null) {
            this.modules = new JobsList();
        }
        this.modules.getJobs().addAll(modules);
    }

    public void setModulesList(JobsList jobsList) {
        this.modules = jobsList;
    }

    @Override
    public int compareTo(Job other) {
        return this.getName().compareTo(other.getName());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Job) {
            return this.getName().equals(((Job)obj).getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getName();
    }
}

