/*
 * Decompiled with CFR 0.152.
 */
package com.marvelution.jira.plugins.hudson.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="healthReport")
public class HealthReport
implements Comparable<HealthReport> {
    public static final HealthReport NO_RECENT_BUILDS = new HealthReport("No recent build failures", "health-80plus.gif", 100);
    private String description;
    private String icon;
    private int score;

    public HealthReport(String description, String icon, int score) {
        this.setDescription(description);
        this.setIcon(icon);
        this.setScore(score);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        if (score < 0 || score > 100) {
            throw new IllegalArgumentException("score must be between 0 and 100 percent");
        }
        this.score = score;
    }

    @Override
    public int compareTo(HealthReport other) {
        return new Integer(this.getScore()).compareTo(new Integer(other.getScore()));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof HealthReport) {
            HealthReport other = (HealthReport)obj;
            return this.getDescription().equals(other.getDescription()) && Integer.valueOf(this.getScore()).equals(other.getScore()) && this.getIcon().equals(other.getIcon());
        }
        return false;
    }

    public int hashCode() {
        return Integer.valueOf(this.getScore()).hashCode();
    }

    public String toString() {
        return this.getDescription();
    }
}

