/*
 * Decompiled with CFR 0.152.
 */
package com.marvelution.jira.plugins.hudson.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="jiraApi")
public final class ApiImplementation {
    @XStreamOmitField
    private static ApiImplementation api;
    private String version;
    @XStreamOmitField
    private Set<String> compatibleVersions;

    private ApiImplementation(String version, Set<String> compatibleVersions) {
        this.version = version;
        this.compatibleVersions = compatibleVersions;
    }

    public static ApiImplementation getApiImplementation() throws IOException {
        if (api == null) {
            Properties props = new Properties();
            props.load(ApiImplementation.class.getResourceAsStream("ApiImplementation.properties"));
            String currentVersion = props.getProperty("current.version");
            HashSet<String> versions = new HashSet<String>();
            for (String version : props.getProperty(currentVersion, currentVersion).split(" ,;:")) {
                versions.add(version);
            }
            api = new ApiImplementation(currentVersion, Collections.unmodifiableSet(versions));
        }
        return api;
    }

    public String getVersion() {
        return this.version;
    }

    public String getMajorVersion() {
        return this.getVersion().split("\\.")[0];
    }

    public Set<String> getCompatibleVersions() {
        return this.compatibleVersions;
    }

    public boolean isCompatibleWith(ApiImplementation other) {
        return this.getMajorVersion().equals(other.getMajorVersion()) || this.getVersion().equals(other.getVersion()) || this.getCompatibleVersions().contains(other.getVersion());
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof ApiImplementation) {
            return this.getVersion().equals(((ApiImplementation)other).getVersion());
        }
        return false;
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    public String toString() {
        return this.version;
    }
}

