/*
 * Decompiled with CFR 0.152.
 */
package com.marvelution.jira.plugins.hudson.model;

import com.marvelution.jira.plugins.hudson.model.BuildArtifact;
import com.marvelution.jira.plugins.hudson.model.HudsonServerAware;
import com.marvelution.jira.plugins.hudson.model.Result;
import com.marvelution.jira.plugins.hudson.model.State;
import com.marvelution.jira.plugins.hudson.model.TestResult;
import com.marvelution.jira.plugins.hudson.model.triggers.Trigger;
import com.marvelution.jira.plugins.hudson.xstream.converters.ResultConverter;
import com.marvelution.jira.plugins.hudson.xstream.converters.StateConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="build")
public class Build
implements HudsonServerAware,
Comparable<Build> {
    @XStreamOmitField
    private int hudsonServerId;
    private int number;
    private String url;
    private String jobName;
    private String jobUrl;
    @XStreamImplicit(itemFieldName="trigger")
    private List<Trigger> triggers;
    @XStreamImplicit(itemFieldName="relatedIssueKey")
    private Set<String> relatedIssueKeys;
    @XStreamImplicit(itemFieldName="artifact")
    private List<BuildArtifact> artifacts;
    @XStreamAlias(value="testResult")
    private TestResult testResult;
    private long duration = 0L;
    private long timestamp = 0L;
    @XStreamConverter(value=ResultConverter.class)
    @XStreamAlias(value="result")
    private Result result;
    @XStreamConverter(value=StateConverter.class)
    @XStreamAlias(value="state")
    private State state;

    public Build(int number, String jobName) {
        this.setNumber(number);
        this.setJobName(jobName);
    }

    @Override
    public int getHudsonServerId() {
        return this.hudsonServerId;
    }

    @Override
    public void setHudsonServerId(int hudsonServerId) {
        this.hudsonServerId = hudsonServerId;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobUrl() {
        return this.jobUrl;
    }

    public void setJobUrl(String jobUrl) {
        this.jobUrl = jobUrl;
    }

    public List<Trigger> getTriggers() {
        if (this.triggers == null) {
            this.triggers = new ArrayList<Trigger>();
        }
        return this.triggers;
    }

    public void setTriggers(List<Trigger> triggers) {
        this.triggers = triggers;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public Set<String> getRelatedIssueKeys() {
        if (this.relatedIssueKeys == null) {
            this.relatedIssueKeys = new HashSet<String>();
        }
        return this.relatedIssueKeys;
    }

    public void setRelatedIssueKeys(Set<String> relatedIssueKeys) {
        this.relatedIssueKeys = relatedIssueKeys;
    }

    public List<BuildArtifact> getArtifacts() {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList<BuildArtifact>();
        }
        return this.artifacts;
    }

    public void setArtifacts(List<BuildArtifact> artifacts) {
        this.artifacts = artifacts;
    }

    public TestResult getTestResult() {
        return this.testResult;
    }

    public void setTestResult(TestResult testResult) {
        this.testResult = testResult;
    }

    @Override
    public int compareTo(Build other) {
        return Long.valueOf(this.getTimestamp()).compareTo(other.getTimestamp());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Build) {
            Build other = (Build)obj;
            return Integer.valueOf(this.getNumber()).equals(other.getNumber()) && this.getJobName().equals(other.getJobName());
        }
        return false;
    }

    public int hashCode() {
        return Integer.valueOf(this.getNumber()).hashCode();
    }

    public String toString() {
        return this.getJobName() + " #" + this.getNumber();
    }
}

