/*
 * Decompiled with CFR 0.152.
 */
package com.marshalchen.ultimaterecyclerview.ui;

import android.app.Activity;
import android.content.Context;
import android.support.v4.view.ViewCompat;
import android.util.DisplayMetrics;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

public class AdGoogleDisplaySupport {
    public static final int BANNER = 101;
    public static final int FULL_BANNER = 102;
    public static final int LARGE_BANNER = 103;
    public static final int LEADERBOARD = 104;
    public static final int MEDIUM_RECTANGLE = 105;
    public static final int WIDE_SKYSCRAPER = 106;

    public static RelativeLayout initialSupport(Activity activity, DisplayMetrics dm) {
        activity.getWindowManager().getDefaultDisplay().getMetrics(dm);
        RelativeLayout layout2 = new RelativeLayout((Context)activity);
        return layout2;
    }

    public static <ad extends ViewGroup> void panelAdjust(ad view, int height_pixel, int AdType) {
        AdGoogleDisplaySupport.panelAdjustApply(view, height_pixel);
    }

    public static <ad extends ViewGroup> void panelAdjust(ad view, int height_pixel) {
        AdGoogleDisplaySupport.panelAdjustApply(view, height_pixel);
    }

    private static <ad extends ViewGroup> void panelAdjustApply(ad view, int height_pixel) {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, height_pixel);
        params.addRule(11, -1);
        params.addRule(9, -1);
        params.addRule(10, -1);
        params.addRule(8, -1);
        params.addRule(14, -1);
        view.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public static double ratioMatching(DisplayMetrics Dm) {
        switch (Dm.densityDpi) {
            case 320: {
                return 1.2;
            }
        }
        return 1.2;
    }

    public static int defaultHeight(DisplayMetrics Dm) {
        return AdGoogleDisplaySupport.defaultHeightApply(Dm, 105);
    }

    public static int defaultHeight(DisplayMetrics Dm, int type) {
        return AdGoogleDisplaySupport.defaultHeightApply(Dm, type);
    }

    private static int defaultHeightApply(DisplayMetrics Dm, int type) {
        if (type == 105) {
            switch (Dm.widthPixels) {
                case 1080: {
                    return 600;
                }
                case 720: {
                    return 400;
                }
            }
            return 500;
        }
        if (type == 101) {
            switch (Dm.widthPixels) {
                case 1080: {
                    return 100;
                }
                case 720: {
                    return 80;
                }
            }
            return 80;
        }
        return 100;
    }

    public static <T extends ViewGroup> void scale(T view, double scaleRatio) {
        ViewCompat.setScaleX(view, (float)((float)scaleRatio));
        ViewCompat.setScaleY(view, (float)((float)scaleRatio));
    }
}

