/*
 * Decompiled with CFR 0.152.
 */
package com.marshalchen.ultimaterecyclerview.swipe;

import android.support.v7.widget.RecyclerView;
import com.marshalchen.ultimaterecyclerview.UltimateRecyclerviewViewHolder;
import com.marshalchen.ultimaterecyclerview.swipe.SimpleSwipeListener;
import com.marshalchen.ultimaterecyclerview.swipe.SwipeItemManagerInterface;
import com.marshalchen.ultimaterecyclerview.swipe.SwipeLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SwipeItemManagerImpl
implements SwipeItemManagerInterface {
    public final int INVALID_POSITION = -1;
    private SwipeItemManagerInterface.Mode mode = SwipeItemManagerInterface.Mode.Single;
    protected int mOpenPosition = -1;
    protected Set<Integer> mOpenPositions = new HashSet<Integer>();
    protected Set<SwipeLayout> mShownLayouts = new HashSet<SwipeLayout>();
    protected RecyclerView.Adapter mAdapter;

    public SwipeItemManagerImpl(RecyclerView.Adapter adapter) {
        if (adapter == null) {
            throw new IllegalArgumentException("Adapter can not be null");
        }
        if (!(adapter instanceof SwipeItemManagerInterface)) {
            throw new IllegalArgumentException("adapter should implement the SwipeAdapterInterface");
        }
        this.mAdapter = adapter;
    }

    @Override
    public SwipeItemManagerInterface.Mode getMode() {
        return this.mode;
    }

    @Override
    public void setMode(SwipeItemManagerInterface.Mode mode) {
        this.mode = mode;
        this.mOpenPositions.clear();
        this.mShownLayouts.clear();
        this.mOpenPosition = -1;
    }

    private void initialize(UltimateRecyclerviewViewHolder targetViewHolder, int position) {
        targetViewHolder.onLayoutListener = new OnLayoutListener(position);
        targetViewHolder.swipeMemory = new SwipeMemory(position);
        targetViewHolder.position = position;
        targetViewHolder.swipeLayout.addSwipeListener(targetViewHolder.swipeMemory);
        targetViewHolder.swipeLayout.addOnLayoutListener(targetViewHolder.onLayoutListener);
    }

    public void updateConvertView(UltimateRecyclerviewViewHolder targetViewHolder, int position) {
        SwipeLayout swipeLayout;
        if (targetViewHolder.onLayoutListener == null) {
            this.initialize(targetViewHolder, position);
        }
        if ((swipeLayout = targetViewHolder.swipeLayout) == null) {
            throw new IllegalStateException("can not find SwipeLayout in target view");
        }
        this.mShownLayouts.add(swipeLayout);
        ((SwipeMemory)targetViewHolder.swipeMemory).setPosition(position);
        ((OnLayoutListener)targetViewHolder.onLayoutListener).setPosition(position);
        targetViewHolder.position = position;
    }

    @Override
    public void openItem(int position) {
        if (this.mode == SwipeItemManagerInterface.Mode.Multiple) {
            if (!this.mOpenPositions.contains(position)) {
                this.mOpenPositions.add(position);
            }
        } else {
            this.mOpenPosition = position;
        }
    }

    @Override
    public void closeItem(int position) {
        if (this.mode == SwipeItemManagerInterface.Mode.Multiple) {
            this.mOpenPositions.remove(position);
        } else if (this.mOpenPosition == position) {
            this.mOpenPosition = -1;
        }
    }

    @Override
    public void closeAllExcept(SwipeLayout layout2) {
        for (SwipeLayout s : this.mShownLayouts) {
            if (s == layout2) continue;
            s.close();
        }
    }

    @Override
    public void removeShownLayouts(SwipeLayout layout2) {
        this.mShownLayouts.remove((Object)layout2);
    }

    @Override
    public List<Integer> getOpenItems() {
        if (this.mode == SwipeItemManagerInterface.Mode.Multiple) {
            return new ArrayList<Integer>(this.mOpenPositions);
        }
        return Arrays.asList(this.mOpenPosition);
    }

    @Override
    public List<SwipeLayout> getOpenLayouts() {
        return new ArrayList<SwipeLayout>(this.mShownLayouts);
    }

    @Override
    public boolean isOpen(int position) {
        if (this.mode == SwipeItemManagerInterface.Mode.Multiple) {
            return this.mOpenPositions.contains(position);
        }
        return this.mOpenPosition == position;
    }

    private class SwipeMemory
    extends SimpleSwipeListener {
        private int position;

        SwipeMemory(int position) {
            this.position = position;
        }

        @Override
        public void onClose(SwipeLayout layout2) {
            if (SwipeItemManagerImpl.this.mode == SwipeItemManagerInterface.Mode.Multiple) {
                SwipeItemManagerImpl.this.mOpenPositions.remove(this.position);
            } else {
                SwipeItemManagerImpl.this.mOpenPosition = -1;
            }
        }

        @Override
        public void onStartOpen(SwipeLayout layout2) {
            if (SwipeItemManagerImpl.this.mode == SwipeItemManagerInterface.Mode.Single) {
                SwipeItemManagerImpl.this.closeAllExcept(layout2);
            }
        }

        @Override
        public void onOpen(SwipeLayout layout2) {
            if (SwipeItemManagerImpl.this.mode == SwipeItemManagerInterface.Mode.Multiple) {
                SwipeItemManagerImpl.this.mOpenPositions.add(this.position);
            } else {
                SwipeItemManagerImpl.this.closeAllExcept(layout2);
                SwipeItemManagerImpl.this.mOpenPosition = this.position;
            }
        }

        public void setPosition(int position) {
            this.position = position;
        }
    }

    private class OnLayoutListener
    implements SwipeLayout.OnLayout {
        private int position;

        OnLayoutListener(int position) {
            this.position = position;
        }

        public void setPosition(int position) {
            this.position = position;
        }

        @Override
        public void onLayout(SwipeLayout v) {
            if (SwipeItemManagerImpl.this.isOpen(this.position)) {
                v.open(false, false);
            } else {
                v.close(false, false);
            }
        }
    }
}

