/*
 * Decompiled with CFR 0.152.
 */
package com.marshalchen.ultimaterecyclerview.expanx.Util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.util.Log;
import android.webkit.MimeTypeMap;
import android.widget.Toast;
import com.marshalchen.ultimaterecyclerview.expanx.ExpandableItemData;
import com.marshalchen.ultimaterecyclerview.expanx.SmartItem;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class DataUtil {
    public static final String TAG = "TreeList";

    public static List<SmartItem> getSmallList(String[] list) {
        ArrayList<SmartItem> items = new ArrayList<SmartItem>();
        for (int i = 0; i < list.length - 2; i += 2) {
            items.add(SmartItem.child(list[i], list[i + 1]));
        }
        return items;
    }

    public static List<ExpandableItemData> getChildrenByPath(String path, int treeDepth) {
        ++treeDepth;
        try {
            ArrayList<ExpandableItemData> list = new ArrayList<ExpandableItemData>();
            File file = new File(path);
            File[] children = file.listFiles();
            ArrayList fileList = new ArrayList();
            for (File child2 : children) {
                if (child2.isDirectory()) {
                    list.add(new ExpandableItemData(1026, child2.getName(), child2.getAbsolutePath(), UUID.randomUUID().toString(), treeDepth, null));
                    continue;
                }
                fileList.add(new ExpandableItemData(1135, child2.getName(), child2.getAbsolutePath(), UUID.randomUUID().toString(), treeDepth, null));
            }
            Collections.sort(list);
            Collections.sort(fileList);
            list.addAll(fileList);
            return list;
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("get child error:" + e.getMessage()));
            return null;
        }
    }

    public static void openFileInSystem(String path, Context context) {
        try {
            MimeTypeMap myMime = MimeTypeMap.getSingleton();
            Intent newIntent = new Intent("android.intent.action.VIEW");
            String mimeType = myMime.getMimeTypeFromExtension(DataUtil.fileExt(path).substring(1));
            newIntent.setDataAndType(Uri.fromFile((File)new File(path)), mimeType);
            newIntent.setFlags(0x10000000);
            context.startActivity(newIntent);
        }
        catch (Exception e) {
            Toast.makeText((Context)context, (CharSequence)"No handler for this type of file.", (int)1).show();
        }
    }

    @SuppressLint(value={"DefaultLocale"})
    private static String fileExt(String url) {
        if (url.indexOf("?") > -1) {
            url = url.substring(0, url.indexOf("?"));
        }
        if (url.lastIndexOf(".") == -1) {
            return null;
        }
        String ext = url.substring(url.lastIndexOf("."));
        if (ext.indexOf("%") > -1) {
            ext = ext.substring(0, ext.indexOf("%"));
        }
        if (ext.indexOf("/") > -1) {
            ext = ext.substring(0, ext.indexOf("/"));
        }
        return ext.toLowerCase();
    }
}

