/*
 * Decompiled with CFR 0.152.
 */
package com.marshalchen.ultimaterecyclerview.divideritemdecoration;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.DimenRes;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.marshalchen.ultimaterecyclerview.divideritemdecoration.FlexibleDividerDecoration;

public class VerticalDividerItemDecoration
extends FlexibleDividerDecoration {
    private MarginProvider mMarginProvider;

    protected VerticalDividerItemDecoration(Builder builder) {
        super(builder);
        this.mMarginProvider = builder.mMarginProvider;
    }

    @Override
    protected Rect getDividerBound(int position, RecyclerView parent2, View child2) {
        Rect bounds = new Rect(0, 0, 0, 0);
        int transitionX = (int)ViewCompat.getTranslationX((View)child2);
        int transitionY = (int)ViewCompat.getTranslationY((View)child2);
        RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child2.getLayoutParams();
        bounds.top = parent2.getPaddingTop() + this.mMarginProvider.dividerTopMargin(position, parent2) + transitionY;
        bounds.bottom = parent2.getHeight() - parent2.getPaddingBottom() - this.mMarginProvider.dividerBottomMargin(position, parent2) + transitionY;
        int dividerSize = this.getDividerSize(position, parent2);
        if (this.mDividerType == FlexibleDividerDecoration.DividerType.DRAWABLE) {
            bounds.left = child2.getRight() + params.leftMargin + transitionX;
            bounds.right = bounds.left + dividerSize;
        } else {
            bounds.right = bounds.left = child2.getRight() + params.leftMargin + dividerSize / 2 + transitionX;
        }
        return bounds;
    }

    @Override
    protected void setItemOffsets(Rect outRect, int position, RecyclerView parent2) {
        outRect.set(0, 0, this.getDividerSize(position, parent2), 0);
    }

    private int getDividerSize(int position, RecyclerView parent2) {
        if (this.mPaintProvider != null) {
            return (int)this.mPaintProvider.dividerPaint(position, parent2).getStrokeWidth();
        }
        if (this.mSizeProvider != null) {
            return this.mSizeProvider.dividerSize(position, parent2);
        }
        if (this.mDrawableProvider != null) {
            Drawable drawable2 = this.mDrawableProvider.drawableProvider(position, parent2);
            return drawable2.getIntrinsicWidth();
        }
        throw new RuntimeException("failed to get size");
    }

    public static class Builder
    extends FlexibleDividerDecoration.Builder<Builder> {
        private MarginProvider mMarginProvider = new MarginProvider(){

            @Override
            public int dividerTopMargin(int position, RecyclerView parent2) {
                return 0;
            }

            @Override
            public int dividerBottomMargin(int position, RecyclerView parent2) {
                return 0;
            }
        };

        public Builder(Context context) {
            super(context);
        }

        public Builder margin(final int topMargin, final int bottomMargin) {
            return this.marginProvider(new MarginProvider(){

                @Override
                public int dividerTopMargin(int position, RecyclerView parent2) {
                    return topMargin;
                }

                @Override
                public int dividerBottomMargin(int position, RecyclerView parent2) {
                    return bottomMargin;
                }
            });
        }

        public Builder margin(int verticalMargin) {
            return this.margin(verticalMargin, verticalMargin);
        }

        public Builder marginResId(@DimenRes int topMarginId, @DimenRes int bottomMarginId) {
            return this.margin(this.mResources.getDimensionPixelSize(topMarginId), this.mResources.getDimensionPixelSize(bottomMarginId));
        }

        public Builder marginResId(@DimenRes int verticalMarginId) {
            return this.marginResId(verticalMarginId, verticalMarginId);
        }

        public Builder marginProvider(MarginProvider provider) {
            this.mMarginProvider = provider;
            return this;
        }

        public VerticalDividerItemDecoration build() {
            this.checkBuilderParams();
            return new VerticalDividerItemDecoration(this);
        }
    }

    public static interface MarginProvider {
        public int dividerTopMargin(int var1, RecyclerView var2);

        public int dividerBottomMargin(int var1, RecyclerView var2);
    }
}

