/*
 * Decompiled with CFR 0.152.
 */
package com.marshalchen.ultimaterecyclerview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Build;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.LayoutRes;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.support.v7.widget.Toolbar;
import android.util.AttributeSet;
import android.util.SparseIntArray;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.marshalchen.ultimaterecyclerview.ObservableScrollState;
import com.marshalchen.ultimaterecyclerview.ObservableScrollViewCallbacks;
import com.marshalchen.ultimaterecyclerview.R;
import com.marshalchen.ultimaterecyclerview.Scrollable;
import com.marshalchen.ultimaterecyclerview.URLogs;
import com.marshalchen.ultimaterecyclerview.UltimateViewAdapter;
import com.marshalchen.ultimaterecyclerview.ui.DividerItemDecoration;
import com.marshalchen.ultimaterecyclerview.ui.VerticalSwipeRefreshLayout;
import com.marshalchen.ultimaterecyclerview.ui.floatingactionbutton.FloatingActionButton;
import com.marshalchen.ultimaterecyclerview.ui.floatingactionbutton.FloatingActionsMenu;
import com.marshalchen.ultimaterecyclerview.uiUtils.SavedStateScrolling;
import com.nineoldandroids.animation.ValueAnimator;
import com.nineoldandroids.view.ViewHelper;

public class UltimateRecyclerView
extends FrameLayout
implements Scrollable {
    public RecyclerView mRecyclerView;
    protected FloatingActionButton defaultFloatingActionButton;
    private OnLoadMoreListener onLoadMoreListener;
    private int lastVisibleItemPosition;
    protected RecyclerView.OnScrollListener mOnScrollListener;
    protected LAYOUT_MANAGER_TYPE layoutManagerType;
    private boolean isLoadingMore = false;
    protected int mPadding;
    protected int mPaddingTop;
    protected int mPaddingBottom;
    protected int mPaddingLeft;
    protected int mPaddingRight;
    protected boolean mClipToPadding;
    private UltimateViewAdapter mAdapter;
    private int mPrevFirstVisiblePosition;
    private int mPrevFirstVisibleChildHeight = -1;
    private int mPrevScrolledChildrenHeight;
    private int mPrevScrollY;
    private int mScrollY;
    private SparseIntArray mChildrenHeights = new SparseIntArray();
    private ObservableScrollState mObservableScrollState;
    private ObservableScrollViewCallbacks mCallbacks;
    private boolean mFirstScroll;
    private boolean mDragging;
    private boolean mIntercepted;
    private boolean mIsLoadMoreWidgetEnabled;
    private MotionEvent mPrevMoveEvent;
    private ViewGroup mTouchInterceptionViewGroup;
    protected ViewStub mEmpty;
    protected View mEmptyView;
    protected int mEmptyId;
    protected ViewStub mFloatingButtonViewStub;
    protected View mFloatingButtonView;
    protected int mFloatingButtonId;
    protected int[] defaultSwipeToDismissColors = null;
    public int showLoadMoreItemNum = 3;
    public VerticalSwipeRefreshLayout mSwipeRefreshLayout;
    private static final int SCROLLBARS_NONE = 0;
    private static final int SCROLLBARS_VERTICAL = 1;
    private static final int SCROLLBARS_HORIZONTAL = 2;
    private int mScrollbarsStyle;
    private int mVisibleItemCount = 0;
    private int mTotalItemCount = 0;
    private int previousTotal = 0;
    private int mFirstVisibleItem;
    private CustomRelativeWrapper mHeader;
    private int mTotalYScrolled;
    private final float SCROLL_MULTIPLIER = 0.5f;
    private OnParallaxScroll mParallaxScroll;
    private static boolean isParallaxHeader = false;

    public UltimateRecyclerView(Context context) {
        super(context);
        this.initViews();
    }

    public UltimateRecyclerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(attrs);
        this.initViews();
    }

    public UltimateRecyclerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(attrs);
        this.initViews();
    }

    public void setRecylerViewBackgroundColor(@ColorInt int color2) {
        this.mRecyclerView.setBackgroundColor(color2);
    }

    protected void initViews() {
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.ultimate_recycler_view_layout, (ViewGroup)this);
        this.mRecyclerView = (RecyclerView)view.findViewById(R.id.ultimate_list);
        this.mSwipeRefreshLayout = (VerticalSwipeRefreshLayout)view.findViewById(R.id.swipe_refresh_layout);
        this.setScrollbars();
        this.mSwipeRefreshLayout.setEnabled(false);
        if (this.mRecyclerView != null) {
            this.mRecyclerView.setClipToPadding(this.mClipToPadding);
            if ((float)this.mPadding != -1.1f) {
                this.mRecyclerView.setPadding(this.mPadding, this.mPadding, this.mPadding, this.mPadding);
            } else {
                this.mRecyclerView.setPadding(this.mPaddingLeft, this.mPaddingTop, this.mPaddingRight, this.mPaddingBottom);
            }
        }
        this.defaultFloatingActionButton = (FloatingActionButton)view.findViewById(R.id.defaultFloatingActionButton);
        this.setDefaultScrollListener();
        this.mEmpty = (ViewStub)view.findViewById(R.id.emptyview);
        this.mFloatingButtonViewStub = (ViewStub)view.findViewById(R.id.floatingActionViewStub);
        this.mEmpty.setLayoutResource(this.mEmptyId);
        this.mFloatingButtonViewStub.setLayoutResource(this.mFloatingButtonId);
        if (this.mEmptyId != 0) {
            this.mEmptyView = this.mEmpty.inflate();
        }
        this.mEmpty.setVisibility(8);
    }

    public View getEmptyView() {
        return this.mEmptyView;
    }

    public void setEmptyView(@LayoutRes int emptyResourceId) {
        this.mEmptyId = emptyResourceId;
        this.mEmpty.setLayoutResource(this.mEmptyId);
        if (this.mEmptyId != 0) {
            this.mEmptyView = this.mEmpty.inflate();
        }
        this.mEmpty.setVisibility(8);
    }

    public void showEmptyView() {
        if (this.mEmptyId != 0) {
            this.mEmpty.setVisibility(0);
        }
    }

    public void hideEmptyView() {
        if (this.mEmptyId != 0) {
            this.mEmpty.setVisibility(8);
        }
    }

    public void showFloatingButtonView() {
        if (this.mFloatingButtonId != 0) {
            this.mFloatingButtonView = this.mFloatingButtonViewStub.inflate();
            this.mFloatingButtonView.setVisibility(0);
        }
    }

    protected void setScrollbars() {
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        switch (this.mScrollbarsStyle) {
            case 1: {
                this.mSwipeRefreshLayout.removeView((View)this.mRecyclerView);
                View verticalView = inflater.inflate(R.layout.vertical_recycler_view, (ViewGroup)this.mSwipeRefreshLayout, true);
                this.mRecyclerView = (RecyclerView)verticalView.findViewById(R.id.ultimate_list);
                break;
            }
            case 2: {
                this.mSwipeRefreshLayout.removeView((View)this.mRecyclerView);
                View horizontalView = inflater.inflate(R.layout.horizontal_recycler_view, (ViewGroup)this.mSwipeRefreshLayout, true);
                this.mRecyclerView = (RecyclerView)horizontalView.findViewById(R.id.ultimate_list);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initAttrs(AttributeSet attrs) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.UltimateRecyclerview);
        try {
            this.mPadding = (int)typedArray.getDimension(R.styleable.UltimateRecyclerview_recyclerviewPadding, -1.1f);
            this.mPaddingTop = (int)typedArray.getDimension(R.styleable.UltimateRecyclerview_recyclerviewPaddingTop, 0.0f);
            this.mPaddingBottom = (int)typedArray.getDimension(R.styleable.UltimateRecyclerview_recyclerviewPaddingBottom, 0.0f);
            this.mPaddingLeft = (int)typedArray.getDimension(R.styleable.UltimateRecyclerview_recyclerviewPaddingLeft, 0.0f);
            this.mPaddingRight = (int)typedArray.getDimension(R.styleable.UltimateRecyclerview_recyclerviewPaddingRight, 0.0f);
            this.mClipToPadding = typedArray.getBoolean(R.styleable.UltimateRecyclerview_recyclerviewClipToPadding, false);
            this.mEmptyId = typedArray.getResourceId(R.styleable.UltimateRecyclerview_recyclerviewEmptyView, 0);
            this.mFloatingButtonId = typedArray.getResourceId(R.styleable.UltimateRecyclerview_recyclerviewFloatingActionView, 0);
            this.mScrollbarsStyle = typedArray.getInt(R.styleable.UltimateRecyclerview_recyclerviewScrollbars, 0);
            int colorList = typedArray.getResourceId(R.styleable.UltimateRecyclerview_recyclerviewDefaultSwipeColor, 0);
            if (colorList != 0) {
                this.defaultSwipeToDismissColors = this.getResources().getIntArray(colorList);
            }
        }
        finally {
            typedArray.recycle();
        }
    }

    protected void setDefaultScrollListener() {
        this.mRecyclerView.removeOnScrollListener(this.mOnScrollListener);
        this.mOnScrollListener = new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (UltimateRecyclerView.this.mHeader != null) {
                    UltimateRecyclerView.this.mTotalYScrolled = UltimateRecyclerView.this.mTotalYScrolled + dy;
                    if (isParallaxHeader) {
                        UltimateRecyclerView.this.translateHeader(UltimateRecyclerView.this.mTotalYScrolled);
                    }
                }
                UltimateRecyclerView.this.enableShoworHideToolbarAndFloatingButton(recyclerView);
            }
        };
        this.mRecyclerView.addOnScrollListener(this.mOnScrollListener);
    }

    private void setObserableScrollListener() {
        this.mRecyclerView.removeOnScrollListener(this.mOnScrollListener);
        this.mOnScrollListener = new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                UltimateRecyclerView.this.enableShoworHideToolbarAndFloatingButton(recyclerView);
            }
        };
        this.mRecyclerView.addOnScrollListener(this.mOnScrollListener);
    }

    public void enableLoadmore() {
        this.mRecyclerView.removeOnScrollListener(this.mOnScrollListener);
        this.mOnScrollListener = new RecyclerView.OnScrollListener(){
            private int[] lastPositions;

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (UltimateRecyclerView.this.mHeader != null) {
                    UltimateRecyclerView.this.mTotalYScrolled = UltimateRecyclerView.this.mTotalYScrolled + dy;
                    if (isParallaxHeader) {
                        UltimateRecyclerView.this.translateHeader(UltimateRecyclerView.this.mTotalYScrolled);
                    }
                }
                RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
                if (UltimateRecyclerView.this.layoutManagerType == null) {
                    if (layoutManager instanceof GridLayoutManager) {
                        UltimateRecyclerView.this.layoutManagerType = LAYOUT_MANAGER_TYPE.GRID;
                    } else if (layoutManager instanceof LinearLayoutManager) {
                        UltimateRecyclerView.this.layoutManagerType = LAYOUT_MANAGER_TYPE.LINEAR;
                    } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                        UltimateRecyclerView.this.layoutManagerType = LAYOUT_MANAGER_TYPE.STAGGERED_GRID;
                    } else {
                        throw new RuntimeException("Unsupported LayoutManager used. Valid ones are LinearLayoutManager, GridLayoutManager and StaggeredGridLayoutManager");
                    }
                }
                switch (UltimateRecyclerView.this.layoutManagerType) {
                    case LINEAR: {
                        UltimateRecyclerView.this.mVisibleItemCount = layoutManager.getChildCount();
                        UltimateRecyclerView.this.mTotalItemCount = layoutManager.getItemCount();
                    }
                    case GRID: {
                        UltimateRecyclerView.this.lastVisibleItemPosition = ((LinearLayoutManager)layoutManager).findLastVisibleItemPosition();
                        UltimateRecyclerView.this.mFirstVisibleItem = ((LinearLayoutManager)layoutManager).findFirstVisibleItemPosition();
                        break;
                    }
                    case STAGGERED_GRID: {
                        StaggeredGridLayoutManager staggeredGridLayoutManager = (StaggeredGridLayoutManager)layoutManager;
                        if (this.lastPositions == null) {
                            this.lastPositions = new int[staggeredGridLayoutManager.getSpanCount()];
                        }
                        staggeredGridLayoutManager.findLastVisibleItemPositions(this.lastPositions);
                        UltimateRecyclerView.this.lastVisibleItemPosition = UltimateRecyclerView.this.findMax(this.lastPositions);
                        staggeredGridLayoutManager.findFirstVisibleItemPositions(this.lastPositions);
                        UltimateRecyclerView.this.mFirstVisibleItem = UltimateRecyclerView.this.findMin(this.lastPositions);
                    }
                }
                if (UltimateRecyclerView.this.isLoadingMore && UltimateRecyclerView.this.mTotalItemCount > UltimateRecyclerView.this.previousTotal) {
                    UltimateRecyclerView.this.isLoadingMore = false;
                    UltimateRecyclerView.this.previousTotal = UltimateRecyclerView.this.mTotalItemCount;
                }
                if (!UltimateRecyclerView.this.isLoadingMore && UltimateRecyclerView.this.mTotalItemCount - UltimateRecyclerView.this.mVisibleItemCount <= UltimateRecyclerView.this.mFirstVisibleItem) {
                    UltimateRecyclerView.this.onLoadMoreListener.loadMore(UltimateRecyclerView.this.mRecyclerView.getAdapter().getItemCount(), UltimateRecyclerView.this.lastVisibleItemPosition);
                    UltimateRecyclerView.this.isLoadingMore = true;
                    UltimateRecyclerView.this.previousTotal = UltimateRecyclerView.this.mTotalItemCount;
                }
                UltimateRecyclerView.this.enableShoworHideToolbarAndFloatingButton(recyclerView);
            }
        };
        this.mRecyclerView.addOnScrollListener(this.mOnScrollListener);
        if (this.mAdapter != null && this.mAdapter.getCustomLoadMoreView() == null) {
            this.mAdapter.setCustomLoadMoreView(LayoutInflater.from((Context)this.getContext()).inflate(R.layout.bottom_progressbar, null));
        }
        this.mIsLoadMoreWidgetEnabled = true;
    }

    public void reenableLoadmore() {
        this.enableLoadmore();
        if (this.mAdapter != null) {
            this.mAdapter.setCustomLoadMoreView(LayoutInflater.from((Context)this.getContext()).inflate(R.layout.bottom_progressbar, null));
            this.mAdapter.isLoadMoreChanged = false;
        }
        this.mIsLoadMoreWidgetEnabled = true;
    }

    public void reenableLoadmore(View customLoadingMoreView) {
        this.enableLoadmore();
        if (this.mAdapter != null) {
            this.mAdapter.setCustomLoadMoreView(customLoadingMoreView);
            this.mAdapter.isLoadMoreChanged = false;
        }
        this.mIsLoadMoreWidgetEnabled = true;
    }

    public boolean isLoadMoreEnabled() {
        return this.mIsLoadMoreWidgetEnabled;
    }

    public void disableLoadmore() {
        this.setDefaultScrollListener();
        if (this.mAdapter != null) {
            this.mAdapter.swipeCustomLoadMoreView(LayoutInflater.from((Context)this.getContext()).inflate(R.layout.empty_progressbar, null));
        }
        this.mIsLoadMoreWidgetEnabled = false;
    }

    protected void enableShoworHideToolbarAndFloatingButton(RecyclerView recyclerView) {
        if (this.mCallbacks != null && this.getChildCount() > 0) {
            int firstVisiblePosition = recyclerView.getChildAdapterPosition(recyclerView.getChildAt(0));
            int lastVisiblePosition = recyclerView.getChildAdapterPosition(recyclerView.getChildAt(recyclerView.getChildCount() - 1));
            try {
                int i = firstVisiblePosition;
                int j = 0;
                while (i <= lastVisiblePosition) {
                    int childHeight = 0;
                    View child2 = recyclerView.getChildAt(j);
                    if ((this.mChildrenHeights.indexOfKey(i) < 0 || child2 != null && child2.getHeight() != this.mChildrenHeights.get(i)) && child2 != null) {
                        childHeight = child2.getHeight();
                    }
                    this.mChildrenHeights.put(i, childHeight);
                    ++i;
                    ++j;
                }
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                URLogs.e(e, "");
            }
            View firstVisibleChild = recyclerView.getChildAt(0);
            if (firstVisibleChild != null) {
                int i;
                int skippedChildrenHeight;
                if (this.mPrevFirstVisiblePosition < firstVisiblePosition) {
                    skippedChildrenHeight = 0;
                    if (firstVisiblePosition - this.mPrevFirstVisiblePosition != 1) {
                        for (i = firstVisiblePosition - 1; i > this.mPrevFirstVisiblePosition; --i) {
                            if (0 < this.mChildrenHeights.indexOfKey(i)) {
                                skippedChildrenHeight += this.mChildrenHeights.get(i);
                                continue;
                            }
                            skippedChildrenHeight += firstVisibleChild.getHeight();
                        }
                    }
                    this.mPrevScrolledChildrenHeight += this.mPrevFirstVisibleChildHeight + skippedChildrenHeight;
                    this.mPrevFirstVisibleChildHeight = firstVisibleChild.getHeight();
                } else if (firstVisiblePosition < this.mPrevFirstVisiblePosition) {
                    skippedChildrenHeight = 0;
                    if (this.mPrevFirstVisiblePosition - firstVisiblePosition != 1) {
                        for (i = this.mPrevFirstVisiblePosition - 1; i > firstVisiblePosition; --i) {
                            if (0 < this.mChildrenHeights.indexOfKey(i)) {
                                skippedChildrenHeight += this.mChildrenHeights.get(i);
                                continue;
                            }
                            skippedChildrenHeight += firstVisibleChild.getHeight();
                        }
                    }
                    this.mPrevScrolledChildrenHeight -= firstVisibleChild.getHeight() + skippedChildrenHeight;
                    this.mPrevFirstVisibleChildHeight = firstVisibleChild.getHeight();
                } else if (firstVisiblePosition == 0) {
                    this.mPrevFirstVisibleChildHeight = firstVisibleChild.getHeight();
                    this.mPrevScrolledChildrenHeight = 0;
                }
                if (this.mPrevFirstVisibleChildHeight < 0) {
                    this.mPrevFirstVisibleChildHeight = 0;
                }
                this.mScrollY = this.mPrevScrolledChildrenHeight - firstVisibleChild.getTop();
                this.mPrevFirstVisiblePosition = firstVisiblePosition;
                this.mCallbacks.onScrollChanged(this.mScrollY, this.mFirstScroll, this.mDragging);
                if (this.mPrevScrollY < this.mScrollY) {
                    if (this.mFirstScroll) {
                        this.mFirstScroll = false;
                        this.mObservableScrollState = ObservableScrollState.STOP;
                    }
                    this.mObservableScrollState = ObservableScrollState.UP;
                } else {
                    this.mObservableScrollState = this.mScrollY < this.mPrevScrollY ? ObservableScrollState.DOWN : ObservableScrollState.STOP;
                }
                if (this.mFirstScroll) {
                    this.mFirstScroll = false;
                }
                this.mPrevScrollY = this.mScrollY;
            }
        }
    }

    public void setOnScrollListener(RecyclerView.OnScrollListener customOnScrollListener) {
        this.mRecyclerView.setOnScrollListener(customOnScrollListener);
    }

    public void addOnScrollListener(RecyclerView.OnScrollListener customOnScrollListener) {
        this.mRecyclerView.addOnScrollListener(customOnScrollListener);
    }

    public void removeOnScrollListener(RecyclerView.OnScrollListener customOnScrollListener) {
        this.mRecyclerView.removeOnScrollListener(customOnScrollListener);
    }

    public void addItemDividerDecoration(Context context) {
        DividerItemDecoration itemDecoration = new DividerItemDecoration(context, 1);
        this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)itemDecoration);
    }

    public void swapAdapter(UltimateViewAdapter adapter, boolean removeAndRecycleExistingViews) {
        this.mRecyclerView.swapAdapter((RecyclerView.Adapter)adapter, removeAndRecycleExistingViews);
    }

    public void addItemDecoration(RecyclerView.ItemDecoration itemDecoration) {
        this.mRecyclerView.addItemDecoration(itemDecoration);
    }

    public void addItemDecoration(RecyclerView.ItemDecoration itemDecoration, int index) {
        this.mRecyclerView.addItemDecoration(itemDecoration, index);
    }

    public void setItemAnimator(RecyclerView.ItemAnimator animator) {
        this.mRecyclerView.setItemAnimator(animator);
    }

    public RecyclerView.ItemAnimator getItemAnimator() {
        return this.mRecyclerView.getItemAnimator();
    }

    public void setDefaultOnRefreshListener(SwipeRefreshLayout.OnRefreshListener listener) {
        this.mSwipeRefreshLayout.setEnabled(true);
        if (this.defaultSwipeToDismissColors != null && this.defaultSwipeToDismissColors.length > 0) {
            this.mSwipeRefreshLayout.setColorSchemeColors(this.defaultSwipeToDismissColors);
        } else {
            this.mSwipeRefreshLayout.setColorSchemeResources(new int[]{17170459, 17170452, 17170456, 0x1060016});
        }
        this.mSwipeRefreshLayout.setOnRefreshListener(listener);
    }

    public void setDefaultSwipeToRefreshColorScheme(int ... colors) {
        this.mSwipeRefreshLayout.setColorSchemeColors(colors);
    }

    public void setOnLoadMoreListener(OnLoadMoreListener onLoadMoreListener) {
        this.onLoadMoreListener = onLoadMoreListener;
    }

    public void setLayoutManager(RecyclerView.LayoutManager manager) {
        this.mRecyclerView.setLayoutManager(manager);
    }

    public RecyclerView.Adapter getAdapter() {
        return this.mRecyclerView.getAdapter();
    }

    public void setAdapter(UltimateViewAdapter adapter) {
        this.mAdapter = adapter;
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        if (this.mSwipeRefreshLayout != null) {
            this.mSwipeRefreshLayout.setRefreshing(false);
        }
        if (this.mAdapter != null) {
            this.mAdapter.registerAdapterDataObserver(new RecyclerView.AdapterDataObserver(){

                public void onItemRangeChanged(int positionStart, int itemCount) {
                    super.onItemRangeChanged(positionStart, itemCount);
                    UltimateRecyclerView.this.updateHelperDisplays();
                }

                public void onItemRangeInserted(int positionStart, int itemCount) {
                    super.onItemRangeInserted(positionStart, itemCount);
                    UltimateRecyclerView.this.updateHelperDisplays();
                }

                public void onItemRangeRemoved(int positionStart, int itemCount) {
                    super.onItemRangeRemoved(positionStart, itemCount);
                    UltimateRecyclerView.this.updateHelperDisplays();
                }

                public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
                    super.onItemRangeMoved(fromPosition, toPosition, itemCount);
                    UltimateRecyclerView.this.updateHelperDisplays();
                }

                public void onChanged() {
                    super.onChanged();
                    UltimateRecyclerView.this.updateHelperDisplays();
                }
            });
        }
        if ((adapter == null || this.mAdapter.getAdapterItemCount() == 0) && this.mEmptyId != 0) {
            this.mEmpty.setVisibility(0);
        }
    }

    private void updateHelperDisplays() {
        this.isLoadingMore = false;
        if (this.mSwipeRefreshLayout != null) {
            this.mSwipeRefreshLayout.setRefreshing(false);
        }
        if (this.mAdapter == null) {
            return;
        }
        if (this.mAdapter.getAdapterItemCount() == 0) {
            this.mEmpty.setVisibility(this.mEmptyId != 0 ? 0 : 8);
        } else if (this.mEmptyId != 0) {
            this.mEmpty.setVisibility(8);
        }
        if (this.mAdapter.getCustomLoadMoreView() == null) {
            return;
        }
        if (this.mAdapter.getAdapterItemCount() >= this.showLoadMoreItemNum && this.mAdapter.getCustomLoadMoreView().getVisibility() == 8) {
            this.mAdapter.getCustomLoadMoreView().setVisibility(0);
        }
        if (this.mAdapter.getAdapterItemCount() < this.showLoadMoreItemNum) {
            this.mAdapter.getCustomLoadMoreView().setVisibility(8);
        }
    }

    @Deprecated
    public void setAdapter(RecyclerView.Adapter adapter) {
        this.mRecyclerView.setAdapter(adapter);
        if (this.mSwipeRefreshLayout != null) {
            this.mSwipeRefreshLayout.setRefreshing(false);
        }
        adapter.registerAdapterDataObserver(new RecyclerView.AdapterDataObserver(){

            public void onItemRangeChanged(int positionStart, int itemCount) {
                super.onItemRangeChanged(positionStart, itemCount);
                this.update();
            }

            public void onItemRangeInserted(int positionStart, int itemCount) {
                super.onItemRangeInserted(positionStart, itemCount);
                this.update();
            }

            public void onItemRangeRemoved(int positionStart, int itemCount) {
                super.onItemRangeRemoved(positionStart, itemCount);
                this.update();
            }

            public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
                super.onItemRangeMoved(fromPosition, toPosition, itemCount);
                this.update();
            }

            public void onChanged() {
                super.onChanged();
                this.update();
            }

            private void update() {
                UltimateRecyclerView.this.isLoadingMore = false;
                if (UltimateRecyclerView.this.mSwipeRefreshLayout != null) {
                    UltimateRecyclerView.this.mSwipeRefreshLayout.setRefreshing(false);
                }
            }
        });
    }

    public void setHasFixedSize(boolean hasFixedSize) {
        this.mRecyclerView.setHasFixedSize(hasFixedSize);
    }

    public void setRefreshing(boolean refreshing) {
        if (this.mSwipeRefreshLayout != null) {
            this.mSwipeRefreshLayout.setRefreshing(refreshing);
        }
    }

    public void enableDefaultSwipeRefresh(boolean isSwipeRefresh) {
        if (this.mSwipeRefreshLayout != null) {
            this.mSwipeRefreshLayout.setEnabled(isSwipeRefresh);
        }
    }

    private int findMax(int[] lastPositions) {
        int max = Integer.MIN_VALUE;
        for (int value : lastPositions) {
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    private int findMin(int[] lastPositions) {
        int min = Integer.MAX_VALUE;
        for (int value : lastPositions) {
            if (value == -1 || value >= min) continue;
            min = value;
        }
        return min;
    }

    public void setParallaxHeader(@LayoutRes int mLayout) {
        View h_layout = LayoutInflater.from((Context)this.getContext()).inflate(mLayout, null);
        this.setParallaxHeader(h_layout);
    }

    public void setParallaxHeader(View header) {
        this.mHeader = new CustomRelativeWrapper(header.getContext());
        this.mHeader.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        this.mHeader.addView(header, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        if (this.mAdapter != null) {
            this.mAdapter.setCustomHeaderView(this.mHeader);
        }
        isParallaxHeader = true;
    }

    public void setNormalHeader(View header) {
        this.setParallaxHeader(header);
        isParallaxHeader = false;
    }

    public void setOnParallaxScroll(OnParallaxScroll parallaxScroll) {
        this.mParallaxScroll = parallaxScroll;
        this.mParallaxScroll.onParallaxScroll(0.0f, 0.0f, (View)this.mHeader);
    }

    private void translateHeader(float of) {
        float ofCalculated = of * 0.5f;
        if (Build.VERSION.SDK_INT >= 11) {
            this.mHeader.setTranslationY(ofCalculated);
        } else {
            TranslateAnimation anim = new TranslateAnimation(0.0f, 0.0f, ofCalculated, ofCalculated);
            anim.setFillAfter(true);
            anim.setDuration(0L);
            this.mHeader.startAnimation((Animation)anim);
        }
        this.mHeader.setClipY(Math.round(ofCalculated));
        if (this.mParallaxScroll != null) {
            float left = Math.min(1.0f, ofCalculated / ((float)this.mHeader.getHeight() * 0.5f));
            this.mParallaxScroll.onParallaxScroll(left, of, (View)this.mHeader);
        }
    }

    @Override
    public void setScrollViewCallbacks(ObservableScrollViewCallbacks listener) {
        this.mCallbacks = listener;
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedStateScrolling ss = (SavedStateScrolling)state;
        this.mPrevFirstVisiblePosition = ss.prevFirstVisiblePosition;
        this.mPrevFirstVisibleChildHeight = ss.prevFirstVisibleChildHeight;
        this.mPrevScrolledChildrenHeight = ss.prevScrolledChildrenHeight;
        this.mPrevScrollY = ss.prevScrollY;
        this.mScrollY = ss.scrollY;
        this.mChildrenHeights = ss.childrenHeights;
        super.onRestoreInstanceState(ss.getSuperState());
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedStateScrolling ss = new SavedStateScrolling(superState);
        ss.prevFirstVisiblePosition = this.mPrevFirstVisiblePosition;
        ss.prevFirstVisibleChildHeight = this.mPrevFirstVisibleChildHeight;
        ss.prevScrolledChildrenHeight = this.mPrevScrolledChildrenHeight;
        ss.prevScrollY = this.mPrevScrollY;
        ss.scrollY = this.mScrollY;
        ss.childrenHeights = this.mChildrenHeights;
        return ss;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mCallbacks != null) {
            switch (ev.getActionMasked()) {
                case 0: {
                    this.mDragging = true;
                    this.mFirstScroll = true;
                    this.mCallbacks.onDownMotionEvent();
                    break;
                }
                case 1: 
                case 3: {
                    this.mIntercepted = false;
                    this.mDragging = false;
                    this.mCallbacks.onUpOrCancelMotionEvent(this.mObservableScrollState);
                }
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    @Override
    public void setTouchInterceptionViewGroup(ViewGroup viewGroup) {
        this.mTouchInterceptionViewGroup = viewGroup;
        this.setObserableScrollListener();
    }

    @Override
    public void scrollVerticallyTo(int y) {
        URLogs.d("vertically");
        View firstVisibleChild = this.getChildAt(0);
        if (firstVisibleChild != null) {
            int baseHeight = firstVisibleChild.getHeight();
            int position = y / baseHeight;
            this.scrollVerticallyToPosition(position);
        }
    }

    public void scrollVerticallyToPosition(int position) {
        RecyclerView.LayoutManager lm = this.getLayoutManager();
        if (lm != null && lm instanceof LinearLayoutManager) {
            ((LinearLayoutManager)lm).scrollToPositionWithOffset(position, 0);
        } else {
            lm.scrollToPosition(position);
        }
    }

    @Override
    public int getCurrentScrollY() {
        return this.mScrollY;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        URLogs.d("ev---" + ev);
        if (this.mCallbacks != null) {
            switch (ev.getActionMasked()) {
                case 1: 
                case 3: {
                    this.mIntercepted = false;
                    this.mDragging = false;
                    this.mCallbacks.onUpOrCancelMotionEvent(this.mObservableScrollState);
                    break;
                }
                case 2: {
                    if (this.mPrevMoveEvent == null) {
                        this.mPrevMoveEvent = ev;
                    }
                    float diffY = ev.getY() - this.mPrevMoveEvent.getY();
                    this.mPrevMoveEvent = MotionEvent.obtainNoHistory((MotionEvent)ev);
                    if (!((float)this.getCurrentScrollY() - diffY <= 0.0f)) break;
                    if (this.mIntercepted) {
                        return false;
                    }
                    final ViewGroup parent2 = this.mTouchInterceptionViewGroup == null ? (ViewGroup)this.getParent() : this.mTouchInterceptionViewGroup;
                    float offsetX = 0.0f;
                    float offsetY = 0.0f;
                    for (UltimateRecyclerView v = this; v != null && v != parent2; v = (View)v.getParent()) {
                        offsetX += (float)(v.getLeft() - v.getScrollX());
                        offsetY += (float)(v.getTop() - v.getScrollY());
                    }
                    final MotionEvent event = MotionEvent.obtainNoHistory((MotionEvent)ev);
                    event.offsetLocation(offsetX, offsetY);
                    if (parent2.onInterceptTouchEvent(event)) {
                        this.mIntercepted = true;
                        event.setAction(0);
                        this.post(new Runnable(){

                            @Override
                            public void run() {
                                parent2.dispatchTouchEvent(event);
                            }
                        });
                        return false;
                    }
                    return super.onTouchEvent(ev);
                }
            }
        }
        return super.onTouchEvent(ev);
    }

    public boolean toolbarIsShown(Toolbar mToolbar) {
        return ViewHelper.getTranslationY((View)mToolbar) == 0.0f;
    }

    public boolean toolbarIsHidden(Toolbar mToolbar) {
        return ViewHelper.getTranslationY((View)mToolbar) == (float)(-mToolbar.getHeight());
    }

    @Deprecated
    public void showToolbarAndFAB(Toolbar mToolbar, UltimateRecyclerView ultimateRecyclerView, int screenHeight) {
        this.showToolbar(mToolbar, ultimateRecyclerView, screenHeight);
        this.showDefaultFloatingActionButton();
    }

    @Deprecated
    public void hideToolbarAndFAB(Toolbar mToolbar, UltimateRecyclerView ultimateRecyclerView, int screenHeight) {
        this.hideToolbar(mToolbar, ultimateRecyclerView, screenHeight);
        this.hideDefaultFloatingActionButton();
    }

    public void showToolbar(Toolbar mToolbar, UltimateRecyclerView ultimateRecyclerView, int screenHeight) {
        this.moveToolbar(mToolbar, ultimateRecyclerView, screenHeight, 0.0f);
    }

    public void hideToolbar(Toolbar mToolbar, UltimateRecyclerView ultimateRecyclerView, int screenHeight) {
        this.moveToolbar(mToolbar, ultimateRecyclerView, screenHeight, -mToolbar.getHeight());
    }

    public void showView(View mView, UltimateRecyclerView ultimateRecyclerView, int screenHeight) {
        this.moveView(mView, ultimateRecyclerView, screenHeight, 0.0f);
    }

    public void hideView(View mView, UltimateRecyclerView ultimateRecyclerView, int screenHeight) {
        this.moveView(mView, ultimateRecyclerView, screenHeight, -mView.getHeight());
    }

    protected void moveToolbar(final Toolbar mToolbar, final UltimateRecyclerView ultimateRecyclerView, final int screenheight, float toTranslationY) {
        if (ViewHelper.getTranslationY((View)mToolbar) == toTranslationY) {
            return;
        }
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{ViewHelper.getTranslationY((View)mToolbar), toTranslationY}).setDuration(200L);
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float translationY = ((Float)animation.getAnimatedValue()).floatValue();
                ViewHelper.setTranslationY((View)mToolbar, (float)translationY);
                ViewHelper.setTranslationY((View)ultimateRecyclerView, (float)translationY);
                ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)ultimateRecyclerView.getLayoutParams();
                layoutParams.height = (int)(-translationY) + screenheight - layoutParams.topMargin;
                ultimateRecyclerView.requestLayout();
            }
        });
        animator.start();
    }

    protected void moveView(final View mView, final UltimateRecyclerView ultimateRecyclerView, final int screenheight, float toTranslationY) {
        if (ViewHelper.getTranslationY((View)mView) == toTranslationY) {
            return;
        }
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{ViewHelper.getTranslationY((View)mView), toTranslationY}).setDuration(200L);
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float translationY = ((Float)animation.getAnimatedValue()).floatValue();
                ViewHelper.setTranslationY((View)mView, (float)translationY);
                ViewHelper.setTranslationY((View)ultimateRecyclerView, (float)translationY);
                ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)ultimateRecyclerView.getLayoutParams();
                layoutParams.height = (int)(-translationY) + screenheight - layoutParams.topMargin;
                ultimateRecyclerView.requestLayout();
            }
        });
        animator.start();
    }

    public FloatingActionButton getDefaultFloatingActionButton() {
        return this.defaultFloatingActionButton;
    }

    public void setDefaultFloatingActionButton(FloatingActionButton defaultFloatingActionButton) {
        this.defaultFloatingActionButton = defaultFloatingActionButton;
    }

    public View getCustomFloatingActionView() {
        return this.mFloatingButtonView;
    }

    public void showFloatingActionMenu() {
        if (this.mFloatingButtonView != null) {
            ((FloatingActionsMenu)this.mFloatingButtonView).hide(false);
        }
    }

    public void hideFloatingActionMenu() {
        if (this.mFloatingButtonView != null) {
            ((FloatingActionsMenu)this.mFloatingButtonView).hide(true);
        }
    }

    public void showFloatingActionButton() {
        if (this.mFloatingButtonView != null) {
            ((FloatingActionButton)this.mFloatingButtonView).hide(false);
        }
    }

    public void hideFloatingActionButton() {
        if (this.mFloatingButtonView != null) {
            ((FloatingActionButton)this.mFloatingButtonView).hide(true);
        }
    }

    public void showDefaultFloatingActionButton() {
        this.defaultFloatingActionButton.hide(false);
    }

    public void hideDefaultFloatingActionButton() {
        this.defaultFloatingActionButton.hide(true);
    }

    public void displayCustomFloatingActionView(boolean b) {
        if (this.mFloatingButtonView != null) {
            this.mFloatingButtonView.setVisibility(b ? 0 : 4);
        }
    }

    public void displayDefaultFloatingActionButton(boolean b) {
        this.defaultFloatingActionButton.setVisibility(b ? 0 : 4);
    }

    public void removeItemDecoration(RecyclerView.ItemDecoration decoration) {
        this.mRecyclerView.removeItemDecoration(decoration);
    }

    public void addOnItemTouchListener(RecyclerView.OnItemTouchListener listener) {
        this.mRecyclerView.addOnItemTouchListener(listener);
    }

    public void removeOnItemTouchListener(RecyclerView.OnItemTouchListener listener) {
        this.mRecyclerView.removeOnItemTouchListener(listener);
    }

    public RecyclerView.LayoutManager getLayoutManager() {
        return this.mRecyclerView.getLayoutManager();
    }

    public static class CustomRelativeWrapper
    extends RelativeLayout {
        private int mOffset;

        public CustomRelativeWrapper(Context context) {
            super(context);
        }

        protected void dispatchDraw(Canvas canvas) {
            if (isParallaxHeader) {
                canvas.clipRect(new Rect(this.getLeft(), this.getTop(), this.getRight(), this.getBottom() + this.mOffset));
            }
            super.dispatchDraw(canvas);
        }

        public void setClipY(int offset) {
            this.mOffset = offset;
            this.invalidate();
        }
    }

    public static interface OnParallaxScroll {
        public void onParallaxScroll(float var1, float var2, View var3);
    }

    public static enum LAYOUT_MANAGER_TYPE {
        LINEAR,
        GRID,
        STAGGERED_GRID;

    }

    public static interface OnLoadMoreListener {
        public void loadMore(int var1, int var2);
    }
}

