/*
 * Decompiled with CFR 0.152.
 */
package com.marshalchen.ultimaterecyclerview;

import android.util.Log;

public final class URLogs {
    private static boolean sIsLogEnabled = true;
    private static String sApplicationTag = "Chen";
    private static final String TAG_CONTENT_PRINT = "%s:%s.%s:%d";

    private static StackTraceElement getCurrentStackTraceElement() {
        return Thread.currentThread().getStackTrace()[4];
    }

    public static void trace() {
        if (sIsLogEnabled) {
            Log.d((String)sApplicationTag, (String)URLogs.getContent(URLogs.getCurrentStackTraceElement()));
        }
    }

    private static String getContent(StackTraceElement trace) {
        return String.format(TAG_CONTENT_PRINT, sApplicationTag, trace.getClassName(), trace.getMethodName(), trace.getLineNumber());
    }

    private static String getContents(StackTraceElement trace) {
        return String.format("%s:%s:%d", sApplicationTag, trace.getMethodName(), trace.getLineNumber());
    }

    public static void traceStack() {
        if (sIsLogEnabled) {
            URLogs.traceStack(sApplicationTag, 6);
        }
    }

    public static void traceStack(String tag, int priority) {
        if (sIsLogEnabled) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            Log.println((int)priority, (String)tag, (String)stackTrace[4].toString());
            StringBuilder str = new StringBuilder();
            String prevClass = null;
            for (int i = 5; i < stackTrace.length; ++i) {
                String className = stackTrace[i].getFileName();
                int idx = className.indexOf(".java");
                if (idx >= 0) {
                    className = className.substring(0, idx);
                }
                if (prevClass == null || !prevClass.equals(className)) {
                    str.append(className.substring(0, idx));
                }
                prevClass = className;
                str.append(".").append(stackTrace[i].getMethodName()).append(":").append(stackTrace[i].getLineNumber()).append("->");
            }
            Log.println((int)priority, (String)tag, (String)str.toString());
        }
    }

    public static void v(String msg) {
        if (sIsLogEnabled) {
            Log.v((String)sApplicationTag, (String)(URLogs.getContents(URLogs.getCurrentStackTraceElement()) + ">" + msg));
        }
    }

    public static void d(String tag, String msg) {
        if (sIsLogEnabled) {
            Log.d((String)tag, (String)(URLogs.getContent(URLogs.getCurrentStackTraceElement()) + ">" + msg));
        }
    }

    public static void d(String msg) {
        if (sIsLogEnabled) {
            Log.d((String)sApplicationTag, (String)(URLogs.getContents(URLogs.getCurrentStackTraceElement()) + ">" + msg));
        }
    }

    public static void i(String tag, String msg) {
        if (sIsLogEnabled) {
            Log.i((String)tag, (String)(URLogs.getContent(URLogs.getCurrentStackTraceElement()) + ">" + msg));
        }
    }

    public static void d(String message, Object ... args) {
        if (sIsLogEnabled) {
            URLogs.d(String.format(message, args));
        }
    }

    public static void w(String tag, String msg) {
        if (sIsLogEnabled) {
            Log.w((String)tag, (String)(URLogs.getContent(URLogs.getCurrentStackTraceElement()) + ">" + msg));
        }
    }

    public static void e(String tag, String msg) {
        if (sIsLogEnabled) {
            Log.e((String)tag, (String)(URLogs.getContent(URLogs.getCurrentStackTraceElement()) + ">" + msg));
        }
    }

    public static void i(String msg) {
        if (sIsLogEnabled) {
            Log.i((String)sApplicationTag, (String)(URLogs.getContent(URLogs.getCurrentStackTraceElement()) + ">" + msg));
        }
    }

    public static void w(String msg) {
        if (sIsLogEnabled) {
            Log.w((String)sApplicationTag, (String)(URLogs.getContent(URLogs.getCurrentStackTraceElement()) + ">" + msg));
        }
    }

    public static void e(String msg) {
        if (sIsLogEnabled) {
            Log.e((String)sApplicationTag, (String)(URLogs.getContent(URLogs.getCurrentStackTraceElement()) + "\n>" + msg));
        }
    }

    public static void e(Exception exception) {
        if (sIsLogEnabled) {
            Log.e((String)sApplicationTag, (String)(URLogs.getContent(URLogs.getCurrentStackTraceElement()) + "\n>" + exception.getMessage()));
            exception.printStackTrace();
        }
    }

    public static void e(Exception exception, String string) {
        if (sIsLogEnabled) {
            Log.e((String)sApplicationTag, (String)(URLogs.getContent(URLogs.getCurrentStackTraceElement()) + "\n>" + exception.getMessage() + "\n>" + exception.getStackTrace() + "   " + string));
            exception.printStackTrace();
        }
    }

    public static void e(String string, Exception exception) {
        if (sIsLogEnabled) {
            Log.e((String)sApplicationTag, (String)(URLogs.getContent(URLogs.getCurrentStackTraceElement()) + "\n>" + exception.getMessage() + "\n>" + exception.getStackTrace() + "   " + string));
            exception.printStackTrace();
        }
    }

    public static void e(String tag, String message, Exception exception) {
        if (sIsLogEnabled) {
            Log.e((String)tag, (String)(URLogs.getContent(URLogs.getCurrentStackTraceElement()) + "\n>" + exception.getMessage() + "\n>" + exception.getStackTrace() + "   " + message));
            exception.printStackTrace();
        }
    }

    public static boolean issIsLogEnabled() {
        return sIsLogEnabled;
    }

    public static void setsIsLogEnabled(boolean sIsLogEnabled) {
        URLogs.sIsLogEnabled = sIsLogEnabled;
    }

    public static String getsApplicationTag() {
        return sApplicationTag;
    }

    public static void setsApplicationTag(String sApplicationTag) {
        URLogs.sApplicationTag = sApplicationTag;
    }

    public static String getTagContentPrint() {
        return TAG_CONTENT_PRINT;
    }
}

