/*
 * Decompiled with CFR 0.152.
 */
package com.marshalchen.ultimaterecyclerview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.RecyclerView;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.marshalchen.ultimaterecyclerview.R;

public abstract class DragDropTouchListener
implements RecyclerView.OnItemTouchListener {
    private static final String LOG_TAG = "DRAG-DROP";
    private static final int MOVE_DURATION = 150;
    private RecyclerView recyclerView;
    private Activity activity;
    private Drawable dragHighlight;
    private DisplayMetrics displayMetrics;
    private final int scrollAmount;
    private int downY = -1;
    private int downX = -1;
    private View mobileView;
    private int mobileViewStartY = -1;
    private int mobileViewCurrentPos = -1;
    private int activePointerId;
    private boolean dragging;
    private boolean enabled = true;

    public DragDropTouchListener(RecyclerView recyclerView, Activity activity) {
        this.recyclerView = recyclerView;
        this.activity = activity;
        this.displayMetrics = recyclerView.getResources().getDisplayMetrics();
        this.scrollAmount = (int)(50.0f / this.displayMetrics.density);
        this.dragHighlight = recyclerView.getResources().getDrawable(R.drawable.drag_frame);
    }

    public DragDropTouchListener(RecyclerView recyclerView, Activity activity, Drawable dragHighlight) {
        this(recyclerView, activity);
        this.dragHighlight = dragHighlight;
    }

    public boolean onInterceptTouchEvent(RecyclerView recyclerView, MotionEvent event) {
        if (!this.enabled) {
            return false;
        }
        switch (event.getAction() & 0xFF) {
            case 0: {
                return this.down(event);
            }
            case 2: {
                return this.dragging && this.move(event);
            }
            case 1: {
                return this.up(event);
            }
            case 3: {
                return this.cancel(event);
            }
        }
        return false;
    }

    public void onTouchEvent(RecyclerView view, MotionEvent event) {
        if (!this.dragging) {
            return;
        }
        switch (event.getAction() & 0xFF) {
            case 2: {
                this.move(event);
                break;
            }
            case 1: {
                this.up(event);
                break;
            }
            case 3: {
                this.cancel(event);
            }
        }
    }

    public void startDrag() {
        View viewUnder = this.recyclerView.findChildViewUnder((float)this.downX, (float)this.downY);
        if (viewUnder == null) {
            return;
        }
        this.dragging = true;
        this.mobileViewCurrentPos = this.recyclerView.getChildPosition(viewUnder);
        int[] viewRawCoords = this.getViewRawCoords(viewUnder);
        this.mobileView = this.copyViewAsImage(viewUnder);
        this.mobileView.setX((float)viewRawCoords[0]);
        this.mobileView.setY((float)viewRawCoords[1]);
        this.mobileViewStartY = viewRawCoords[1];
        ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-2, -2);
        this.activity.addContentView(this.mobileView, lp);
        this.mobileView.bringToFront();
        viewUnder.setVisibility(4);
    }

    private boolean down(MotionEvent event) {
        this.activePointerId = event.getPointerId(0);
        this.downY = (int)event.getY();
        this.downX = (int)event.getX();
        return false;
    }

    private boolean move(MotionEvent event) {
        if (this.activePointerId == -1) {
            return false;
        }
        int pointerIndex = event.findPointerIndex(this.activePointerId);
        int currentY = (int)event.getY(pointerIndex);
        int deltaY = currentY - this.downY;
        int mobileViewY = this.mobileViewStartY + deltaY;
        this.mobileView.setY((float)mobileViewY);
        this.switchViewsIfNeeded();
        this.scrollIfNeeded();
        return true;
    }

    private void switchViewsIfNeeded() {
        int pos = this.mobileViewCurrentPos;
        int abovePos = pos - 1;
        int belowPos = pos + 1;
        View aboveView = this.getViewByPosition(abovePos);
        View belowView = this.getViewByPosition(belowPos);
        int mobileViewY = (int)this.mobileView.getY();
        if (aboveView != null && aboveView.getTop() > -1 && mobileViewY < aboveView.getTop()) {
            Log.d((String)LOG_TAG, (String)String.format("Got aboveView with top = %s, for position = %s, %s", aboveView.getTop(), abovePos, aboveView));
            this.doSwitch(aboveView, pos, abovePos);
        }
        if (belowView != null && belowView.getTop() > -1 && mobileViewY > belowView.getTop()) {
            Log.d((String)LOG_TAG, (String)String.format("Got belowView with top = %s, for position = %s, %s", belowView.getTop(), belowPos, belowView));
            this.doSwitch(belowView, pos, belowPos);
        }
    }

    private void doSwitch(View switchView, int originalViewPos, int switchViewPos) {
        View originalView = this.getViewByPosition(originalViewPos);
        int switchViewTop = switchView.getTop();
        int originalViewTop = originalView.getTop();
        int delta = originalViewTop - switchViewTop;
        this.onItemSwitch(this.recyclerView, originalViewPos, switchViewPos);
        switchView.setVisibility(4);
        originalView.setVisibility(0);
        originalView.setTranslationY((float)(-delta));
        originalView.animate().translationYBy((float)delta).setDuration(150L);
        this.mobileViewCurrentPos = switchViewPos;
    }

    private boolean up(MotionEvent event) {
        if (this.dragging) {
            this.onItemDrop(this.recyclerView, this.mobileViewCurrentPos);
        }
        this.reset();
        return false;
    }

    private boolean cancel(MotionEvent event) {
        this.reset();
        return false;
    }

    private void reset() {
        final View view = this.getViewByPosition(this.mobileViewCurrentPos);
        if (view != null && this.mobileView != null) {
            float y = this.getViewRawCoords(view)[1];
            this.mobileView.animate().y(y).setDuration(150L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    view.setVisibility(0);
                    if (DragDropTouchListener.this.mobileView != null) {
                        ViewGroup parent2 = (ViewGroup)DragDropTouchListener.this.mobileView.getParent();
                        parent2.removeView(DragDropTouchListener.this.mobileView);
                        DragDropTouchListener.this.mobileView = null;
                    }
                }
            });
        }
        this.dragging = false;
        this.mobileViewStartY = -1;
        this.mobileViewCurrentPos = -1;
    }

    private View getViewByPosition(int position) {
        RecyclerView.ViewHolder viewHolder = this.recyclerView.findViewHolderForPosition(position);
        return viewHolder == null ? null : viewHolder.itemView;
    }

    private boolean scrollIfNeeded() {
        int height = this.recyclerView.getHeight();
        int hoverViewTop = (int)this.mobileView.getY();
        int hoverHeight = this.mobileView.getHeight();
        if (hoverViewTop <= 0) {
            this.recyclerView.scrollBy(0, -this.scrollAmount);
            return true;
        }
        if (hoverViewTop + hoverHeight >= height) {
            this.recyclerView.scrollBy(0, this.scrollAmount);
            return true;
        }
        return false;
    }

    private ImageView copyViewAsImage(View v) {
        if (v instanceof FrameLayout) {
            FrameLayout frameLayout = (FrameLayout)v;
            Drawable foreground = frameLayout.getForeground();
            if (foreground != null) {
                foreground.setVisible(false, false);
            }
        } else if (v.getBackground() != null) {
            v.getBackground().setVisible(false, false);
        }
        Bitmap bitmap = Bitmap.createBitmap((int)v.getWidth(), (int)v.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        v.draw(canvas);
        if (this.dragHighlight != null) {
            this.dragHighlight.setBounds(0, 0, bitmap.getWidth(), bitmap.getHeight());
            this.dragHighlight.draw(canvas);
        }
        ImageView imageView = new ImageView(this.recyclerView.getContext());
        imageView.setImageBitmap(bitmap);
        return imageView;
    }

    private int[] getViewRawCoords(View locateView) {
        View globalView = this.activity.findViewById(0x1020002);
        int topOffset = this.displayMetrics.heightPixels - globalView.getMeasuredHeight();
        int[] loc = new int[2];
        locateView.getLocationOnScreen(loc);
        loc[1] = loc[1] - topOffset;
        return loc;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected abstract void onItemSwitch(RecyclerView var1, int var2, int var3);

    protected abstract void onItemDrop(RecyclerView var1, int var2);

    public void setCustomDragHighlight(Drawable dragHighlight) {
        this.dragHighlight = dragHighlight;
    }
}

