/*
 * Decompiled with CFR 0.152.
 */
package com.marshalchen.ultimaterecyclerview.ui.floatingactionbutton;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.OvershootInterpolator;
import com.marshalchen.ultimaterecyclerview.Logs;
import com.marshalchen.ultimaterecyclerview.R;
import com.marshalchen.ultimaterecyclerview.ui.floatingactionbutton.AddFloatingActionButton;
import com.nineoldandroids.view.ViewHelper;

public class FloatingActionsMenu
extends ViewGroup {
    private static final int ANIMATION_DURATION = 300;
    private static final float COLLAPSED_PLUS_ROTATION = 0.0f;
    private static final float EXPANDED_PLUS_ROTATION = 135.0f;
    private int mAddButtonPlusColor;
    private int mAddButtonColorNormal;
    private int mAddButtonColorPressed;
    private int mButtonSpacing;
    private boolean mExpanded;
    private boolean isHorizontal = false;
    private AnimatorSet mExpandAnimation = new AnimatorSet().setDuration(300L);
    private AnimatorSet mCollapseAnimation = new AnimatorSet().setDuration(300L);
    private AddFloatingActionButton mAddButton;
    private RotatingDrawable mRotatingDrawable;
    private static Interpolator sExpandInterpolator = new OvershootInterpolator();
    private static Interpolator sCollapseInterpolator = new DecelerateInterpolator(3.0f);
    private static Interpolator sAlphaExpandInterpolator = new DecelerateInterpolator();
    private final Interpolator mInterpolator = new AccelerateDecelerateInterpolator();
    private boolean mHidden = false;
    private float mYDisplayed = -1.0f;
    private float mYHidden = -1.0f;

    public FloatingActionsMenu(Context context) {
        this(context, null);
    }

    public FloatingActionsMenu(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public FloatingActionsMenu(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attributeSet) {
        TypedArray attr;
        this.mAddButtonPlusColor = this.getColor(17170443);
        this.mAddButtonColorNormal = this.getColor(17170451);
        this.mAddButtonColorPressed = this.getColor(17170450);
        this.mButtonSpacing = (int)(this.getResources().getDimension(R.dimen.fab_actions_spacing) - this.getResources().getDimension(R.dimen.fab_shadow_radius) - this.getResources().getDimension(R.dimen.fab_shadow_offset));
        if (attributeSet != null && (attr = context.obtainStyledAttributes(attributeSet, R.styleable.FloatingActionsMenu, 0, 0)) != null) {
            try {
                this.mAddButtonPlusColor = attr.getColor(R.styleable.FloatingActionsMenu_addButtonPlusIconColor, this.getColor(17170443));
                this.mAddButtonColorNormal = attr.getColor(R.styleable.FloatingActionsMenu_addButtonColorNormal, this.getColor(17170451));
                this.mAddButtonColorPressed = attr.getColor(R.styleable.FloatingActionsMenu_addButtonColorPressed, this.getColor(17170450));
                this.isHorizontal = attr.getBoolean(R.styleable.FloatingActionsMenu_addButtonIsHorizontal, false);
            }
            finally {
                attr.recycle();
            }
        }
        WindowManager mWindowManager = (WindowManager)context.getSystemService("window");
        Display display = mWindowManager.getDefaultDisplay();
        Point size = new Point();
        if (Build.VERSION.SDK_INT >= 13) {
            display.getSize(size);
            this.mYHidden = size.y;
        } else {
            this.mYHidden = display.getHeight();
        }
        this.createAddButton(context);
    }

    private void createAddButton(Context context) {
        this.mAddButton = new AddFloatingActionButton(context){

            @Override
            void updateBackground() {
                this.mPlusColor = FloatingActionsMenu.this.mAddButtonPlusColor;
                this.mColorNormal = FloatingActionsMenu.this.mAddButtonColorNormal;
                this.mColorPressed = FloatingActionsMenu.this.mAddButtonColorPressed;
                super.updateBackground();
            }

            @Override
            Drawable getIconDrawable() {
                RotatingDrawable rotatingDrawable = new RotatingDrawable(super.getIconDrawable());
                FloatingActionsMenu.this.mRotatingDrawable = rotatingDrawable;
                OvershootInterpolator interpolator = new OvershootInterpolator();
                ObjectAnimator collapseAnimator = ObjectAnimator.ofFloat((Object)((Object)rotatingDrawable), (String)"rotation", (float[])new float[]{135.0f, 0.0f});
                ObjectAnimator expandAnimator = ObjectAnimator.ofFloat((Object)((Object)rotatingDrawable), (String)"rotation", (float[])new float[]{0.0f, 135.0f});
                collapseAnimator.setInterpolator((TimeInterpolator)interpolator);
                expandAnimator.setInterpolator((TimeInterpolator)interpolator);
                FloatingActionsMenu.this.mExpandAnimation.play((Animator)expandAnimator);
                FloatingActionsMenu.this.mCollapseAnimation.play((Animator)collapseAnimator);
                return rotatingDrawable;
            }
        };
        this.mAddButton.setId(R.id.fab_expand_menu_button);
        this.mAddButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FloatingActionsMenu.this.toggle();
            }
        });
        this.addView((View)this.mAddButton, super.generateDefaultLayoutParams());
    }

    private int getColor(int id2) {
        return this.getResources().getColor(id2);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.measureChildren(widthMeasureSpec, heightMeasureSpec);
        int width = 0;
        int height = 0;
        if (!this.isHorizontal) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                width = Math.max(width, child.getMeasuredWidth());
                height += child.getMeasuredHeight();
            }
            height += this.mButtonSpacing * (this.getChildCount() - 1);
            height = height * 12 / 10;
            this.setMeasuredDimension(width, height);
        } else {
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                height = Math.max(height, child.getMeasuredHeight());
                width += child.getMeasuredWidth();
            }
            width += this.mButtonSpacing * (this.getChildCount() - 1);
            width = width * 12 / 10;
            this.setMeasuredDimension(width, height);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int addButtonY = b - t - this.mAddButton.getMeasuredHeight();
        int addButtonX = r - l - this.mAddButton.getMeasuredWidth();
        if (!this.isHorizontal) {
            this.mAddButton.layout(0, addButtonY, this.mAddButton.getMeasuredWidth(), addButtonY + this.mAddButton.getMeasuredHeight());
        } else {
            this.mAddButton.layout(addButtonX, 0, addButtonX + this.mAddButton.getMeasuredWidth(), this.mAddButton.getMeasuredHeight());
        }
        int bottomY = addButtonY - this.mButtonSpacing;
        int bottomX = addButtonX - this.mButtonSpacing;
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            LayoutParams params;
            View child = this.getChildAt(i);
            if (child == this.mAddButton) continue;
            int childY = bottomY - child.getMeasuredHeight();
            int childX = bottomX - child.getMeasuredWidth();
            if (!this.isHorizontal) {
                child.layout(0, childY, child.getMeasuredWidth(), childY + child.getMeasuredHeight());
            } else {
                Logs.d("num---" + child.getMeasuredWidth() + "   " + child.getMeasuredHeight() + "   " + childX + "   " + childY);
                child.layout(childX, 0, childX + child.getMeasuredWidth(), child.getMeasuredHeight());
            }
            if (!this.isHorizontal) {
                float collapsedTranslation = addButtonY - childY;
                float expandedTranslation = 0.0f;
                child.setTranslationY(this.mExpanded ? expandedTranslation : collapsedTranslation);
                child.setAlpha(this.mExpanded ? 1.0f : 0.0f);
                params = (LayoutParams)child.getLayoutParams();
                params.mCollapseY.setFloatValues(new float[]{expandedTranslation, collapsedTranslation});
                params.mExpandY.setFloatValues(new float[]{collapsedTranslation, expandedTranslation});
                params.setAnimationsTarget(child);
            } else {
                float expandedTranslation = addButtonX - childX;
                float collapsedTranslation = 0.0f;
                child.setTranslationX(this.mExpanded ? expandedTranslation : collapsedTranslation);
                child.setAlpha(this.mExpanded ? 1.0f : 0.0f);
                params = (LayoutParams)child.getLayoutParams();
                params.mCollapseX.setFloatValues(new float[]{collapsedTranslation, expandedTranslation});
                params.mExpandX.setFloatValues(new float[]{expandedTranslation, collapsedTranslation});
                params.setAnimationsTarget(child);
            }
            bottomY = childY - this.mButtonSpacing;
            bottomX = childX - this.mButtonSpacing;
        }
        if (this.mYDisplayed == -1.0f) {
            this.mYDisplayed = ViewHelper.getY((View)this);
        }
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(super.generateDefaultLayoutParams());
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(super.generateLayoutParams(attrs));
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(super.generateLayoutParams(p));
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return super.checkLayoutParams(p);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.bringChildToFront((View)this.mAddButton);
    }

    public void collapse() {
        if (this.mExpanded) {
            this.mExpanded = false;
            this.mCollapseAnimation.start();
            this.mExpandAnimation.cancel();
        }
    }

    public void toggle() {
        if (this.mExpanded) {
            this.collapse();
        } else {
            this.expand();
        }
    }

    public void expand() {
        if (!this.mExpanded) {
            this.mExpanded = true;
            this.mCollapseAnimation.cancel();
            this.mExpandAnimation.start();
        }
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.mExpanded = this.mExpanded;
        return savedState;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof SavedState) {
            SavedState savedState = (SavedState)state;
            this.mExpanded = savedState.mExpanded;
            if (this.mRotatingDrawable != null) {
                this.mRotatingDrawable.setRotation(this.mExpanded ? 135.0f : 0.0f);
            }
            super.onRestoreInstanceState(savedState.getSuperState());
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    public void hide(boolean hide) {
        if (this.mHidden != hide) {
            this.mHidden = hide;
            com.nineoldandroids.animation.ObjectAnimator animator = com.nineoldandroids.animation.ObjectAnimator.ofFloat((Object)((Object)this), (String)"y", (float[])new float[]{this.mHidden ? this.mYHidden : this.mYDisplayed}).setDuration(500L);
            animator.setInterpolator(this.mInterpolator);
            animator.start();
        }
    }

    public static class SavedState
    extends View.BaseSavedState {
        public boolean mExpanded;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable parcel) {
            super(parcel);
        }

        private SavedState(Parcel in) {
            super(in);
            this.mExpanded = in.readInt() == 1;
        }

        public void writeToParcel(@NonNull Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.mExpanded ? 1 : 0);
        }
    }

    private class LayoutParams
    extends ViewGroup.LayoutParams {
        private ObjectAnimator mExpandY;
        private ObjectAnimator mExpandX;
        private ObjectAnimator mExpandAlpha;
        private ObjectAnimator mCollapseY;
        private ObjectAnimator mCollapseX;
        private ObjectAnimator mCollapseAlpha;

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
            this.mExpandY = new ObjectAnimator();
            this.mExpandX = new ObjectAnimator();
            this.mExpandAlpha = new ObjectAnimator();
            this.mCollapseY = new ObjectAnimator();
            this.mCollapseX = new ObjectAnimator();
            this.mCollapseAlpha = new ObjectAnimator();
            this.mExpandY.setInterpolator((TimeInterpolator)sExpandInterpolator);
            this.mExpandX.setInterpolator((TimeInterpolator)sExpandInterpolator);
            this.mExpandAlpha.setInterpolator((TimeInterpolator)sAlphaExpandInterpolator);
            this.mCollapseY.setInterpolator((TimeInterpolator)sCollapseInterpolator);
            this.mCollapseX.setInterpolator((TimeInterpolator)sCollapseInterpolator);
            this.mCollapseAlpha.setInterpolator((TimeInterpolator)sCollapseInterpolator);
            this.mCollapseAlpha.setProperty(View.ALPHA);
            this.mCollapseAlpha.setFloatValues(new float[]{1.0f, 0.0f});
            this.mExpandAlpha.setProperty(View.ALPHA);
            this.mExpandAlpha.setFloatValues(new float[]{0.0f, 1.0f});
            this.mCollapseY.setProperty(View.TRANSLATION_Y);
            this.mCollapseX.setProperty(View.TRANSLATION_X);
            this.mExpandY.setProperty(View.TRANSLATION_Y);
            this.mExpandX.setProperty(View.TRANSLATION_X);
            FloatingActionsMenu.this.mExpandAnimation.play((Animator)this.mExpandAlpha);
            if (!FloatingActionsMenu.this.isHorizontal) {
                FloatingActionsMenu.this.mExpandAnimation.play((Animator)this.mExpandY);
            } else {
                FloatingActionsMenu.this.mExpandAnimation.play((Animator)this.mExpandX);
            }
            FloatingActionsMenu.this.mCollapseAnimation.play((Animator)this.mCollapseAlpha);
            if (!FloatingActionsMenu.this.isHorizontal) {
                FloatingActionsMenu.this.mCollapseAnimation.play((Animator)this.mCollapseY);
            } else {
                FloatingActionsMenu.this.mCollapseAnimation.play((Animator)this.mCollapseX);
            }
        }

        public void setAnimationsTarget(View view) {
            this.mCollapseAlpha.setTarget((Object)view);
            this.mCollapseY.setTarget((Object)view);
            this.mCollapseX.setTarget((Object)view);
            this.mExpandAlpha.setTarget((Object)view);
            this.mExpandY.setTarget((Object)view);
            this.mExpandX.setTarget((Object)view);
        }
    }

    private static class RotatingDrawable
    extends LayerDrawable {
        private float mRotation;

        public RotatingDrawable(Drawable drawable2) {
            super(new Drawable[]{drawable2});
        }

        public float getRotation() {
            return this.mRotation;
        }

        public void setRotation(float rotation) {
            this.mRotation = rotation;
            this.invalidateSelf();
        }

        public void draw(Canvas canvas) {
            canvas.save();
            canvas.rotate(this.mRotation, (float)this.getBounds().centerX(), (float)this.getBounds().centerY());
            super.draw(canvas);
            canvas.restore();
        }
    }
}

