/*
 * Decompiled with CFR 0.152.
 */
package com.marshalchen.ultimaterecyclerview.ui.floatingactionbutton;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.ImageButton;
import com.marshalchen.ultimaterecyclerview.R;
import com.nineoldandroids.animation.ObjectAnimator;
import com.nineoldandroids.view.ViewHelper;

public class FloatingActionButton
extends ImageButton {
    public static final int SIZE_NORMAL = 0;
    public static final int SIZE_MINI = 1;
    private static final int HALF_TRANSPARENT_WHITE = Color.argb((int)128, (int)255, (int)255, (int)255);
    private static final int HALF_TRANSPARENT_BLACK = Color.argb((int)128, (int)0, (int)0, (int)0);
    int mColorNormal;
    int mColorPressed;
    private int mIcon;
    private int mSize;
    private float mCircleSize;
    private float mShadowRadius;
    private float mShadowOffset;
    private int mDrawableSize;
    private final Interpolator mInterpolator = new AccelerateDecelerateInterpolator();
    private boolean mHidden = false;
    private float mYDisplayed = -1.0f;
    private float mYHidden = -1.0f;

    public FloatingActionButton(Context context) {
        this(context, null);
    }

    public FloatingActionButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public FloatingActionButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    void init(Context context, AttributeSet attributeSet) {
        this.mColorNormal = this.getColor(17170451);
        this.mColorPressed = this.getColor(17170450);
        this.mIcon = 0;
        this.mSize = 0;
        if (attributeSet != null) {
            this.initAttributes(context, attributeSet);
        }
        this.mCircleSize = this.getDimension(this.mSize == 0 ? R.dimen.fab_size_normal : R.dimen.fab_size_mini);
        this.mShadowRadius = this.getDimension(R.dimen.fab_shadow_radius);
        this.mShadowOffset = this.getDimension(R.dimen.fab_shadow_offset);
        this.mDrawableSize = (int)(this.mCircleSize + 2.0f * this.mShadowRadius);
        WindowManager mWindowManager = (WindowManager)context.getSystemService("window");
        Display display = mWindowManager.getDefaultDisplay();
        Point size = new Point();
        if (Build.VERSION.SDK_INT >= 13) {
            display.getSize(size);
            this.mYHidden = size.y;
        } else {
            this.mYHidden = display.getHeight();
        }
        this.updateBackground();
    }

    int getColor(int id2) {
        return this.getResources().getColor(id2);
    }

    float getDimension(int id2) {
        return this.getResources().getDimension(id2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAttributes(Context context, AttributeSet attributeSet) {
        TypedArray attr = context.obtainStyledAttributes(attributeSet, R.styleable.FloatActionButton, 0, 0);
        if (attr != null) {
            try {
                this.mColorNormal = attr.getColor(R.styleable.FloatActionButton_colorNormal, this.getColor(17170451));
                this.mColorPressed = attr.getColor(R.styleable.FloatActionButton_colorPressed, this.getColor(17170450));
                this.mSize = attr.getInt(R.styleable.FloatActionButton_size, 0);
                this.mIcon = attr.getResourceId(R.styleable.FloatActionButton_icon, 0);
            }
            finally {
                attr.recycle();
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.mDrawableSize, this.mDrawableSize);
    }

    void updateBackground() {
        float circleLeft = this.mShadowRadius;
        float circleTop = this.mShadowRadius - this.mShadowOffset;
        RectF circleRect = new RectF(circleLeft, circleTop, circleLeft + this.mCircleSize, circleTop + this.mCircleSize);
        LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{this.getResources().getDrawable(this.mSize == 0 ? R.drawable.floating_action_button_fab_bg_normal : R.drawable.floating_action_button_fab_bg_mini), this.createFillDrawable(circleRect), this.createStrokesDrawable(circleRect), this.getIconDrawable()});
        float iconOffset = (this.mCircleSize - this.getDimension(R.dimen.fab_icon_size)) / 2.0f;
        int iconInsetHorizontal = (int)(this.mShadowRadius + iconOffset);
        int iconInsetTop = (int)(circleTop + iconOffset);
        int iconInsetBottom = (int)(this.mShadowRadius + this.mShadowOffset + iconOffset);
        layerDrawable.setLayerInset(3, iconInsetHorizontal, iconInsetTop, iconInsetHorizontal, iconInsetBottom);
        this.setBackgroundCompat((Drawable)layerDrawable);
    }

    Drawable getIconDrawable() {
        if (this.mIcon != 0) {
            return this.getResources().getDrawable(this.mIcon);
        }
        return new ColorDrawable(0);
    }

    private StateListDrawable createFillDrawable(RectF circleRect) {
        StateListDrawable drawable2 = new StateListDrawable();
        drawable2.addState(new int[]{16842919}, this.createCircleDrawable(circleRect, this.mColorPressed));
        drawable2.addState(new int[0], this.createCircleDrawable(circleRect, this.mColorNormal));
        return drawable2;
    }

    private Drawable createCircleDrawable(RectF circleRect, int color) {
        Bitmap bitmap = Bitmap.createBitmap((int)this.mDrawableSize, (int)this.mDrawableSize, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setColor(color);
        canvas.drawOval(circleRect, paint);
        return new BitmapDrawable(this.getResources(), bitmap);
    }

    private int opacityToAlpha(float opacity) {
        return (int)(255.0f * opacity);
    }

    private Drawable createStrokesDrawable(RectF circleRect) {
        Bitmap bitmap = Bitmap.createBitmap((int)this.mDrawableSize, (int)this.mDrawableSize, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        float strokeWidth = this.getDimension(R.dimen.fab_stroke_width);
        float halfStrokeWidth = strokeWidth / 2.0f;
        RectF outerStrokeRect = new RectF(circleRect.left - halfStrokeWidth, circleRect.top - halfStrokeWidth, circleRect.right + halfStrokeWidth, circleRect.bottom + halfStrokeWidth);
        RectF innerStrokeRect = new RectF(circleRect.left + halfStrokeWidth, circleRect.top + halfStrokeWidth, circleRect.right - halfStrokeWidth, circleRect.bottom - halfStrokeWidth);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setStrokeWidth(strokeWidth);
        paint.setStyle(Paint.Style.STROKE);
        paint.setColor(-16777216);
        paint.setAlpha(this.opacityToAlpha(0.02f));
        canvas.drawOval(outerStrokeRect, paint);
        paint.setShader((Shader)new LinearGradient(innerStrokeRect.centerX(), innerStrokeRect.top, innerStrokeRect.centerX(), innerStrokeRect.bottom, new int[]{0, HALF_TRANSPARENT_BLACK, -16777216}, new float[]{0.0f, 0.8f, 1.0f}, Shader.TileMode.CLAMP));
        paint.setAlpha(this.opacityToAlpha(0.04f));
        canvas.drawOval(innerStrokeRect, paint);
        paint.setShader((Shader)new LinearGradient(innerStrokeRect.centerX(), innerStrokeRect.top, innerStrokeRect.centerX(), innerStrokeRect.bottom, new int[]{-1, HALF_TRANSPARENT_WHITE, 0}, new float[]{0.0f, 0.2f, 1.0f}, Shader.TileMode.CLAMP));
        paint.setAlpha(this.opacityToAlpha(0.8f));
        canvas.drawOval(innerStrokeRect, paint);
        return new BitmapDrawable(this.getResources(), bitmap);
    }

    @SuppressLint(value={"NewApi"})
    private void setBackgroundCompat(Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground(drawable2);
        } else {
            this.setBackgroundDrawable(drawable2);
        }
    }

    public void hide(boolean hide) {
        if (this.mHidden != hide) {
            this.mHidden = hide;
            ObjectAnimator animator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"y", (float[])new float[]{this.mHidden ? this.mYHidden : this.mYDisplayed}).setDuration(500L);
            animator.setInterpolator(this.mInterpolator);
            animator.start();
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.mYDisplayed == -1.0f) {
            this.mYDisplayed = ViewHelper.getY((View)this);
        }
    }
}

