/*
 * Decompiled with CFR 0.152.
 */
package com.marshalchen.ultimaterecyclerview.divideritemdecoration;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.RecyclerView;
import android.view.View;

public abstract class FlexibleDividerDecoration
extends RecyclerView.ItemDecoration {
    private static final int DEFAULT_SIZE = 2;
    private static final int[] ATTRS = new int[]{16843284};
    protected DividerType mDividerType = DividerType.DRAWABLE;
    protected VisibilityProvider mVisibilityProvider;
    protected PaintProvider mPaintProvider;
    protected ColorProvider mColorProvider;
    protected DrawableProvider mDrawableProvider;
    protected SizeProvider mSizeProvider;
    private Paint mPaint;

    protected FlexibleDividerDecoration(Builder builder) {
        if (builder.mPaintProvider != null) {
            this.mDividerType = DividerType.PAINT;
            this.mPaintProvider = builder.mPaintProvider;
        } else if (builder.mColorProvider != null) {
            this.mDividerType = DividerType.COLOR;
            this.mColorProvider = builder.mColorProvider;
            this.mPaint = new Paint();
            this.setSizeProvider(builder);
        } else {
            this.mDividerType = DividerType.DRAWABLE;
            if (builder.mDrawableProvider == null) {
                TypedArray a = builder.mContext.obtainStyledAttributes(ATTRS);
                final Drawable divider = a.getDrawable(0);
                a.recycle();
                this.mDrawableProvider = new DrawableProvider(){

                    @Override
                    public Drawable drawableProvider(int position, RecyclerView parent) {
                        return divider;
                    }
                };
            } else {
                this.mDrawableProvider = builder.mDrawableProvider;
            }
            this.mSizeProvider = builder.mSizeProvider;
        }
        this.mVisibilityProvider = builder.mVisibilityProvider;
    }

    private void setSizeProvider(Builder builder) {
        this.mSizeProvider = builder.mSizeProvider;
        if (this.mSizeProvider == null) {
            this.mSizeProvider = new SizeProvider(){

                @Override
                public int dividerSize(int position, RecyclerView parent) {
                    return 2;
                }
            };
        }
    }

    public void onDrawOver(Canvas c, RecyclerView parent, RecyclerView.State state) {
        int childCount = parent.getChildCount();
        block5: for (int i = 0; i < childCount - 1; ++i) {
            View child = parent.getChildAt(i);
            int childPosition = parent.getChildPosition(child);
            if (this.mVisibilityProvider.shouldHideDivider(childPosition, parent)) continue;
            Rect bounds = this.getDividerBound(childPosition, parent, child);
            switch (this.mDividerType) {
                case DRAWABLE: {
                    Drawable drawable2 = this.mDrawableProvider.drawableProvider(childPosition, parent);
                    drawable2.setBounds(bounds);
                    drawable2.draw(c);
                    continue block5;
                }
                case PAINT: {
                    this.mPaint = this.mPaintProvider.dividerPaint(childPosition, parent);
                    c.drawLine((float)bounds.left, (float)bounds.top, (float)bounds.right, (float)bounds.bottom, this.mPaint);
                    continue block5;
                }
                case COLOR: {
                    this.mPaint.setColor(this.mColorProvider.dividerColor(childPosition, parent));
                    this.mPaint.setStrokeWidth((float)this.mSizeProvider.dividerSize(childPosition, parent));
                    c.drawLine((float)bounds.left, (float)bounds.top, (float)bounds.right, (float)bounds.bottom, this.mPaint);
                }
            }
        }
    }

    public void getItemOffsets(Rect rect, View v, RecyclerView parent, RecyclerView.State state) {
        int position = parent.getChildPosition(v);
        this.setItemOffsets(rect, position, parent);
    }

    abstract Rect getDividerBound(int var1, RecyclerView var2, View var3);

    abstract void setItemOffsets(Rect var1, int var2, RecyclerView var3);

    public static class Builder<T extends Builder> {
        private Context mContext;
        private PaintProvider mPaintProvider;
        private ColorProvider mColorProvider;
        private DrawableProvider mDrawableProvider;
        private SizeProvider mSizeProvider;
        private VisibilityProvider mVisibilityProvider = new VisibilityProvider(){

            @Override
            public boolean shouldHideDivider(int position, RecyclerView parent) {
                return false;
            }
        };

        public Builder(Context context) {
            this.mContext = context;
        }

        public T paint(final Paint paint) {
            return this.paintProvider(new PaintProvider(){

                @Override
                public Paint dividerPaint(int position, RecyclerView parent) {
                    return paint;
                }
            });
        }

        public T paintProvider(PaintProvider provider) {
            this.mPaintProvider = provider;
            return (T)this;
        }

        public T color(final int color) {
            return this.colorProvider(new ColorProvider(){

                @Override
                public int dividerColor(int position, RecyclerView parent) {
                    return color;
                }
            });
        }

        public T colorProvider(ColorProvider provider) {
            this.mColorProvider = provider;
            return (T)this;
        }

        public T drawable(int id2) {
            return this.drawable(this.mContext.getResources().getDrawable(id2));
        }

        public T drawable(final Drawable drawable2) {
            return this.drawableProvider(new DrawableProvider(){

                @Override
                public Drawable drawableProvider(int position, RecyclerView parent) {
                    return drawable2;
                }
            });
        }

        public T drawableProvider(DrawableProvider provider) {
            this.mDrawableProvider = provider;
            return (T)this;
        }

        public T size(final int size) {
            return this.sizeProvider(new SizeProvider(){

                @Override
                public int dividerSize(int position, RecyclerView parent) {
                    return size;
                }
            });
        }

        public T sizeProvider(SizeProvider provider) {
            this.mSizeProvider = provider;
            return (T)this;
        }

        public T visibilityProvider(VisibilityProvider provider) {
            this.mVisibilityProvider = provider;
            return (T)this;
        }

        protected void checkBuilderParams() {
            if (this.mPaintProvider != null) {
                if (this.mColorProvider != null) {
                    throw new IllegalArgumentException("Use setColor method of Paint class to specify line color. Do not provider ColorProvider if you set PaintProvider.");
                }
                if (this.mSizeProvider != null) {
                    throw new IllegalArgumentException("Use setStrokeWidth method of Paint class to specify line size. Do not provider SizeProvider if you set PaintProvider.");
                }
            }
        }
    }

    public static interface SizeProvider {
        public int dividerSize(int var1, RecyclerView var2);
    }

    public static interface DrawableProvider {
        public Drawable drawableProvider(int var1, RecyclerView var2);
    }

    public static interface ColorProvider {
        public int dividerColor(int var1, RecyclerView var2);
    }

    public static interface PaintProvider {
        public Paint dividerPaint(int var1, RecyclerView var2);
    }

    public static interface VisibilityProvider {
        public boolean shouldHideDivider(int var1, RecyclerView var2);
    }

    protected static enum DividerType {
        DRAWABLE,
        PAINT,
        COLOR;

    }
}

