/*
 * Decompiled with CFR 0.152.
 */
package com.marlonmafra.android.widget.utils;

import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;

public final class FontCache {
    private final String TAG = "FontCache";
    private static FontCache instance;
    private final Map<String, Typeface> fontMap = new HashMap<String, Typeface>();

    private FontCache() {
    }

    public static FontCache getInstance() {
        if (instance == null) {
            instance = new FontCache();
        }
        return instance;
    }

    private Typeface get(String path) {
        return this.fontMap.get(path);
    }

    public Typeface put(String path, AssetManager assetManager) {
        if (assetManager == null) {
            Log.e((String)"FontCache", (String)"The assetManager cannot be null.");
            throw new IllegalArgumentException("The assetManager cannot be null.");
        }
        if (this.fontMap.containsKey(path)) {
            return this.get(path);
        }
        try {
            Typeface typeface = Typeface.createFromAsset((AssetManager)assetManager, (String)path);
            this.fontMap.put(path, typeface);
            return typeface;
        }
        catch (Exception ex) {
            Log.e((String)"FontCache", (String)"Can not load the font");
            return null;
        }
    }
}

