/*
 * Decompiled with CFR 0.152.
 */
package com.marlonmafra.android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.view.View;
import android.widget.TextView;
import com.marlonmafra.android.widget.R;
import com.marlonmafra.android.widget.utils.Utils;

abstract class TabView {
    private final int radius = 3;
    private final int strokeSize = 1;
    private final View view;
    private final Context context;
    private final TextView txtTitle;

    TabView(Context context, int layout2) {
        this.context = context;
        this.view = View.inflate((Context)context, (int)layout2, null);
        this.txtTitle = (TextView)this.view.findViewById(R.id.txtTitle);
    }

    public void setBackground(int colorSelected, int colorUnselected) {
        if (Build.VERSION.SDK_INT < 16) {
            this.view.setBackgroundDrawable((Drawable)this.getDrawableStates(colorSelected, colorUnselected));
        } else {
            this.view.setBackground((Drawable)this.getDrawableStates(colorSelected, colorUnselected));
        }
    }

    public void setSelected(boolean selected) {
        this.view.setSelected(selected);
    }

    public void setTitle(String title) {
        this.txtTitle.setText((CharSequence)title);
    }

    public void setTextSize(float size) {
        this.txtTitle.setTextSize(2, size);
    }

    public void setTextColorState(ColorStateList colorState) {
        this.txtTitle.setTextColor(colorState);
    }

    public View getView() {
        return this.view;
    }

    public void setTitleTypeFace(Typeface typeFace) {
        this.txtTitle.setTypeface(typeFace);
    }

    private StateListDrawable getDrawableStates(int colorSelected, int colorUnselected) {
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842919}, (Drawable)this.getDrawable(colorSelected, colorSelected));
        stateListDrawable.addState(new int[]{16842908}, (Drawable)this.getDrawable(colorSelected, colorSelected));
        stateListDrawable.addState(new int[]{0x10100A1}, (Drawable)this.getDrawable(colorSelected, colorSelected));
        stateListDrawable.addState(new int[0], (Drawable)this.getDrawable(colorUnselected, colorSelected));
        return stateListDrawable;
    }

    private GradientDrawable getDrawable(int backgroundColor, int strokeColor) {
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setColor(backgroundColor);
        gradientDrawable.setCornerRadii(this.getCornerRadii(Utils.getValueByDensity(this.context, this.radius)));
        gradientDrawable.setStroke(Utils.getValueByDensity(this.context, this.strokeSize), strokeColor);
        return gradientDrawable;
    }

    protected abstract float[] getCornerRadii(int var1);
}

