/*
 * Decompiled with CFR 0.152.
 */
package com.marlonmafra.android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.support.design.widget.TabLayout;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RelativeLayout;
import com.marlonmafra.android.widget.CenterTabView;
import com.marlonmafra.android.widget.LeftTabView;
import com.marlonmafra.android.widget.R;
import com.marlonmafra.android.widget.RightTabView;
import com.marlonmafra.android.widget.TabView;
import com.marlonmafra.android.widget.utils.FontCache;
import com.marlonmafra.android.widget.utils.Utils;
import java.lang.reflect.Field;
import java.util.List;

public class SegmentedTab
extends TabLayout {
    private int tabSelectedColor;
    private int tabUnselectedColor;
    private ColorStateList titleColor;
    private int titleTextSize = 12;
    private Typeface typeface;

    public SegmentedTab(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    public SegmentedTab(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        this.setSelectedTabIndicatorColor(ContextCompat.getColor((Context)this.getContext(), (int)17170445));
        this.setTabMode(1);
        this.setTabGravity(0);
        if (attrs != null) {
            TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.SegmentedTab);
            this.tabSelectedColor = typedArray.getColor(R.styleable.SegmentedTab_tabSelectedColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.cerulean));
            this.tabUnselectedColor = typedArray.getColor(R.styleable.SegmentedTab_tabUnselectedColor, ContextCompat.getColor((Context)this.getContext(), (int)17170443));
            this.titleColor = typedArray.hasValue(R.styleable.SegmentedTab_titleColor) ? typedArray.getColorStateList(R.styleable.SegmentedTab_titleColor) : ContextCompat.getColorStateList((Context)this.getContext(), (int)R.color.segment_control_title);
            this.titleTextSize = typedArray.getDimensionPixelSize(R.styleable.SegmentedTab_titleTextSize, this.titleTextSize);
            String path = typedArray.getString(R.styleable.SegmentedTab_titleFontPath);
            if (path != null) {
                this.typeface = FontCache.getInstance().put(path, this.getContext().getAssets());
            }
            typedArray.recycle();
        }
        this.disablePadding("mTabPaddingStart");
        this.disablePadding("mTabPaddingEnd");
    }

    public void setup(List<String> titles) {
        if (titles.size() <= 1) {
            throw new IllegalArgumentException("You need at least two tabs");
        }
        for (int i = 0; i < this.getTabCount(); ++i) {
            TabLayout.Tab tab = this.getTabAt(i);
            if (tab == null) continue;
            tab.setCustomView(this.getTabView(i, titles));
        }
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.getLayoutParams();
        layoutParams.setMargins(Utils.getValueByDensity(this.getContext(), 20), layoutParams.topMargin, Utils.getValueByDensity(this.getContext(), 20), layoutParams.bottomMargin);
    }

    private View getTabView(int position, List<String> titles) {
        TabView tab;
        if (position == 0) {
            tab = new LeftTabView(this.getContext(), R.layout.left_tab);
            tab.setSelected(true);
        } else {
            tab = position == titles.size() - 1 ? new RightTabView(this.getContext(), R.layout.right_tab) : new CenterTabView(this.getContext(), R.layout.center_tab);
        }
        tab.setBackground(this.tabSelectedColor, this.tabUnselectedColor);
        tab.setTitle(titles.get(position));
        tab.setTextSize(this.titleTextSize);
        tab.setTextColorState(this.titleColor);
        if (this.typeface != null) {
            tab.setTitleTypeFace(this.typeface);
        }
        return tab.getView();
    }

    private void disablePadding(String name) {
        try {
            Field mTabPaddingStart = TabLayout.class.getDeclaredField(name);
            mTabPaddingStart.setAccessible(true);
            mTabPaddingStart.setInt((Object)this, Utils.getValueByDensity(this.getContext(), -0.5));
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

