/*
 * Decompiled with CFR 0.152.
 */
package com.marlonmafra.android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatEditText;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.MotionEvent;
import com.marlonmafra.android.widget.IconPosition;
import com.marlonmafra.android.widget.R;
import com.marlonmafra.android.widget.utils.FontCache;

public class EditTextPassword
extends AppCompatEditText {
    private final int TEXT_PASSWORD = 129;
    private final int NUMBER_PASSWORD = 18;
    private boolean isPasswordVisible = true;
    private Drawable icon;
    private IconPosition iconPosition;
    private Typeface typeface;
    private int showPasswordIcon;
    private int hidePasswordIcon;
    private int inputType;

    public EditTextPassword(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (!this.isInEditMode()) {
            this.init(attrs);
        }
    }

    public EditTextPassword(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (!this.isInEditMode()) {
            this.init(attrs);
        }
    }

    private void init(AttributeSet attrs) {
        if (attrs != null) {
            TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.EditTextPassword);
            this.iconPosition = IconPosition.values()[typedArray.getInteger(R.styleable.EditTextPassword_iconPosition, IconPosition.RIGHT.ordinal())];
            this.showPasswordIcon = typedArray.getResourceId(R.styleable.EditTextPassword_showPasswordIcon, R.drawable.ic_show_password);
            this.hidePasswordIcon = typedArray.getResourceId(R.styleable.EditTextPassword_hidePasswordIcon, R.drawable.ic_hide_password);
            String path = typedArray.getString(R.styleable.EditTextPassword_fontPath);
            if (path != null) {
                this.typeface = FontCache.getInstance().put(path, this.getContext().getAssets());
                this.setFont(this.typeface);
            }
            typedArray.recycle();
        }
        this.inputType = this.getInputType();
        this.togglePassword();
        this.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
            }
        });
    }

    private void togglePassword() {
        if (this.isPasswordVisible) {
            this.setInputType(this.inputType);
        } else if (this.inputType == 129) {
            this.setInputType(128);
        } else {
            this.setInputType(2);
        }
        this.isPasswordVisible = !this.isPasswordVisible;
        int textLength = this.getText().length();
        this.setSelection(textLength, textLength);
        this.setupIcon();
    }

    private void setupIcon() {
        this.icon = this.isPasswordVisible ? this.getDrawable(this.showPasswordIcon) : this.getDrawable(this.hidePasswordIcon);
        switch (this.iconPosition) {
            case LEFT: {
                this.setCompoundDrawablesWithIntrinsicBounds(this.icon, null, null, null);
                break;
            }
            case RIGHT: {
                this.setCompoundDrawablesWithIntrinsicBounds(null, null, this.icon, null);
            }
        }
        this.setCompoundDrawablePadding(10);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 1) {
            int x = (int)event.getX();
            switch (this.iconPosition) {
                case LEFT: {
                    int iconWidth = this.icon.getBounds().width();
                    if (x < this.getPaddingLeft() || x > this.getPaddingLeft() + iconWidth) break;
                    this.togglePassword();
                    event.setAction(3);
                    break;
                }
                case RIGHT: {
                    int iconWidth = this.icon.getBounds().width();
                    if (x < this.getWidth() - this.getPaddingLeft() - iconWidth || x > this.getWidth() + iconWidth - this.getPaddingRight()) break;
                    this.togglePassword();
                    event.setAction(3);
                    break;
                }
            }
        }
        return super.onTouchEvent(event);
    }

    @DrawableRes
    public int getShowPasswordIcon() {
        return this.showPasswordIcon;
    }

    public void setShowPasswordIcon(@DrawableRes int showPasswordIcon) {
        this.showPasswordIcon = showPasswordIcon;
    }

    @DrawableRes
    public int getHidePasswordIcon() {
        return this.hidePasswordIcon;
    }

    public void setHidePasswordIcon(@DrawableRes int hidePasswordIcon) {
        this.hidePasswordIcon = hidePasswordIcon;
    }

    public boolean isPasswordVisible() {
        return this.isPasswordVisible;
    }

    public void setInputType(int inputType) {
        super.setInputType(inputType);
        this.setFont(this.typeface);
    }

    private void setFont(Typeface typeface) {
        if (typeface != null) {
            this.setTypeface(typeface);
        }
    }

    private Drawable getDrawable(int id) {
        return ContextCompat.getDrawable((Context)this.getContext(), (int)id);
    }
}

