/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.schemasloader.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.eval.ServerEvaluationCall;
import com.marklogic.client.ext.file.DocumentFile;
import com.marklogic.client.ext.file.DocumentFileProcessor;
import com.marklogic.client.ext.helper.FilenameUtil;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.client.ext.schemasloader.impl.TdeUtil;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.JacksonHandle;
import com.marklogic.client.io.StringHandle;
import com.marklogic.client.io.marker.AbstractReadHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import java.io.File;
import java.io.IOException;
import org.springframework.util.FileCopyUtils;

class TdeDocumentFileProcessor
extends LoggingObject
implements DocumentFileProcessor {
    private final DatabaseClient contentDatabaseClient;
    private Boolean templateBatchInsertSupported;

    TdeDocumentFileProcessor(DatabaseClient contentDatabaseClient) {
        this.contentDatabaseClient = contentDatabaseClient;
    }

    @Override
    public DocumentFile processDocumentFile(DocumentFile documentFile) {
        boolean isXmlTde;
        String uri = documentFile.getUri();
        String filename = documentFile.getFile() != null ? documentFile.getFile().getName() : null;
        boolean isTdeUri = uri != null && uri.startsWith("/tde");
        boolean isJsonTde = isTdeUri && FilenameUtil.endsWithExtension(filename, ".json") || FilenameUtil.endsWithExtension(filename, ".tdej");
        boolean bl = isXmlTde = isTdeUri && FilenameUtil.endsWithExtension(filename, ".xml") || FilenameUtil.endsWithExtension(filename, ".tdex");
        if (isTdeUri || isJsonTde || isXmlTde) {
            documentFile.getDocumentMetadata().withCollections(new String[]{"http://marklogic.com/xdmp/tde"});
            this.validateTdeTemplate(documentFile);
            if (isJsonTde) {
                documentFile.setFormat(Format.JSON);
            } else if (isXmlTde) {
                documentFile.setFormat(Format.XML);
            }
        }
        return documentFile;
    }

    private boolean isTemplateBatchInsertSupported() {
        if (this.templateBatchInsertSupported == null && this.contentDatabaseClient != null) {
            this.templateBatchInsertSupported = TdeUtil.templateBatchInsertSupported(this.contentDatabaseClient);
        }
        return this.templateBatchInsertSupported;
    }

    private void validateTdeTemplate(DocumentFile documentFile) {
        File file = documentFile.getFile();
        if (this.contentDatabaseClient == null) {
            this.logger.info("No content database client provided, so will not validate TDE templates.");
        } else if (this.isTemplateBatchInsertSupported()) {
            this.logger.debug("Not performing TDE validation; it will be performed automatically via tde.templateBatchInsert.");
        } else {
            String fileContent = null;
            try {
                fileContent = new String(FileCopyUtils.copyToByteArray((File)file));
            }
            catch (IOException e) {
                this.logger.warn("Could not read TDE template from file, will not validate; cause: " + e.getMessage());
            }
            if (fileContent != null) {
                ServerEvaluationCall call = null;
                if (Format.XML.equals((Object)documentFile.getFormat())) {
                    call = this.buildXqueryCall(documentFile, fileContent);
                } else if (Format.JSON.equals((Object)documentFile.getFormat())) {
                    call = this.buildJavascriptCall(documentFile, fileContent);
                } else {
                    this.logger.info("Unrecognized file format, will not try to validate TDE template in file: " + file + "; format: " + documentFile.getFormat());
                }
                if (call != null) {
                    ObjectNode node = (ObjectNode)((JacksonHandle)call.eval((AbstractReadHandle)new JacksonHandle())).get();
                    if (node.get("valid").asBoolean()) {
                        this.logger.info("TDE template passed validation: " + file);
                    } else {
                        throw new RuntimeException(this.format("TDE template failed validation; file: %s; cause: %s", file, node.get("message").asText()));
                    }
                }
            }
        }
    }

    private ServerEvaluationCall buildJavascriptCall(DocumentFile documentFile, String fileContent) {
        StringBuilder script = new StringBuilder("const tde = require('/MarkLogic/tde.xqy'); var template; ");
        script.append(this.format("\ntde.validate([xdmp.toJSON(template)], ['%s'])", documentFile.getUri()));
        return this.contentDatabaseClient.newServerEval().javascript(script.toString()).addVariable("template", (AbstractWriteHandle)new StringHandle(fileContent).withFormat(Format.JSON));
    }

    private ServerEvaluationCall buildXqueryCall(DocumentFile documentFile, String fileContent) {
        StringBuilder script = new StringBuilder("import module namespace tde = 'http://marklogic.com/xdmp/tde' at '/MarkLogic/tde.xqy'; ");
        script.append("\ndeclare variable $template external; ");
        script.append(this.format("\ntde:validate($template, '%s')", documentFile.getUri()));
        return this.contentDatabaseClient.newServerEval().xquery(script.toString()).addVariable("template", (AbstractWriteHandle)new StringHandle(fileContent).withFormat(Format.XML));
    }
}

