/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.schemasloader.impl;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.document.XMLDocumentManager;
import com.marklogic.client.eval.ServerEvaluationCall;
import com.marklogic.client.ext.file.DocumentFile;
import com.marklogic.client.ext.file.DocumentFileProcessor;
import com.marklogic.client.ext.helper.FilenameUtil;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.client.extra.jdom.JDOMHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.StringHandle;
import com.marklogic.client.io.marker.AbstractReadHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.io.marker.DocumentMetadataWriteHandle;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.springframework.util.FileCopyUtils;

class QbvDocumentFileProcessor
extends LoggingObject
implements DocumentFileProcessor {
    public static final String QBV_COLLECTION = "http://marklogic.com/xdmp/qbv";
    private static final String QBV_XML_PLAN_NAMESPACE = "http://marklogic.com/plan";
    private static final String QBV_XML_ROOT_ELEMENT = "query-based-view";
    private final DatabaseClient contentDatabaseClient;
    private final List<DocumentFile> qbvFiles = new ArrayList<DocumentFile>();
    private final XMLDocumentManager schemasDocumentManager;

    QbvDocumentFileProcessor(DatabaseClient schemasDatabaseClient, DatabaseClient contentDatabaseClient) {
        this.schemasDocumentManager = schemasDatabaseClient.newXMLDocumentManager();
        this.contentDatabaseClient = contentDatabaseClient;
    }

    @Override
    public DocumentFile processDocumentFile(DocumentFile documentFile) {
        if (this.isQbvQuery(documentFile)) {
            this.qbvFiles.add(documentFile);
            return null;
        }
        return documentFile;
    }

    private boolean isQbvQuery(DocumentFile documentFile) {
        String uri = documentFile.getUri();
        File file = documentFile.getFile();
        return uri != null && uri.startsWith("/qbv") && file != null && (FilenameUtil.isXqueryFile(file.getName()) || FilenameUtil.isJavascriptFile(file.getName()));
    }

    public void processQbvFiles() {
        this.qbvFiles.forEach(this::processQbvFile);
        this.qbvFiles.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processQbvFile(DocumentFile qbvFile) {
        Document xmlDocument;
        ServerEvaluationCall call;
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.format("Generating Query-Based View for file: %s", qbvFile.getFile().getName()));
        }
        if ((call = this.getServerEvaluationCall(qbvFile)) == null) return;
        StringHandle handleString = new StringHandle();
        try {
            call.eval((AbstractReadHandle)handleString);
        }
        catch (Exception e) {
            throw new RuntimeException(this.format("Query-Based View generation failed for file: %s; cause: %s", qbvFile.getFile().getAbsolutePath(), e.getMessage()));
        }
        if (!Format.XML.equals((Object)handleString.getFormat())) throw new RuntimeException(this.format("Query-Based View generation failed for file: %s; ensure your Optic script includes a call to generate a view; received unexpected response from server: %s", qbvFile.getFile().getAbsolutePath(), handleString.get()));
        try {
            xmlDocument = new SAXBuilder().build((Reader)new StringReader(handleString.get()));
        }
        catch (Exception e) {
            throw new RuntimeException(this.format("Query-Based View generation failed for file: %s; cause: %s", qbvFile.getFile().getAbsolutePath(), e.getMessage()));
        }
        Element root = xmlDocument.getRootElement();
        if (!(QBV_XML_ROOT_ELEMENT.equals(root.getName()) & (root.getNamespace() != null && root.getNamespace().getURI().equals(QBV_XML_PLAN_NAMESPACE)))) throw new RuntimeException(this.format("Query-Based view generation failed for file: %s; received unexpected response from server: %s", qbvFile.getFile().getAbsolutePath(), handleString.get()));
        qbvFile.getDocumentMetadata().getCollections().add((Object)QBV_COLLECTION);
        String uri = qbvFile.getUri() + ".xml";
        this.schemasDocumentManager.write(uri, (DocumentMetadataWriteHandle)qbvFile.getDocumentMetadata(), (AbstractWriteHandle)new JDOMHandle(xmlDocument));
    }

    private ServerEvaluationCall getServerEvaluationCall(DocumentFile qbvFile) {
        String fileContent;
        try {
            fileContent = new String(FileCopyUtils.copyToByteArray((File)qbvFile.getFile()));
        }
        catch (IOException e) {
            throw new RuntimeException(this.format("Unable to generate Query-Based View; could not read from file %s; cause: %s", qbvFile.getFile().getAbsolutePath(), e.getMessage()));
        }
        return FilenameUtil.isXqueryFile(qbvFile.getFile().getName()) ? this.contentDatabaseClient.newServerEval().xquery(fileContent) : this.contentDatabaseClient.newServerEval().javascript(fileContent);
    }
}

