/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.modulesloader.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.admin.ExtensionMetadata;
import com.marklogic.client.admin.NamespacesManager;
import com.marklogic.client.admin.QueryOptionsManager;
import com.marklogic.client.admin.ResourceExtensionsManager;
import com.marklogic.client.admin.ServerConfigurationManager;
import com.marklogic.client.admin.TransformExtensionsManager;
import com.marklogic.client.ext.file.DefaultDocumentFileReader;
import com.marklogic.client.ext.file.DocumentFile;
import com.marklogic.client.ext.file.DocumentFileReader;
import com.marklogic.client.ext.helper.FilenameUtil;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.client.ext.modulesloader.ExtensionMetadataAndParams;
import com.marklogic.client.ext.modulesloader.ExtensionMetadataProvider;
import com.marklogic.client.ext.modulesloader.Modules;
import com.marklogic.client.ext.modulesloader.ModulesFinder;
import com.marklogic.client.ext.modulesloader.ModulesLoader;
import com.marklogic.client.ext.modulesloader.ModulesManager;
import com.marklogic.client.ext.modulesloader.impl.AssetFileLoader;
import com.marklogic.client.ext.modulesloader.impl.DefaultExtensionMetadataProvider;
import com.marklogic.client.ext.modulesloader.impl.LoadModulesFailureListener;
import com.marklogic.client.ext.modulesloader.impl.PropertiesModuleManager;
import com.marklogic.client.ext.modulesloader.impl.SimpleLoadModulesFailureListener;
import com.marklogic.client.ext.modulesloader.impl.StaticChecker;
import com.marklogic.client.ext.tokenreplacer.TokenReplacer;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.StringHandle;
import com.marklogic.client.io.marker.QueryOptionsWriteHandle;
import com.marklogic.client.io.marker.TextWriteHandle;
import com.marklogic.client.io.marker.XMLWriteHandle;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.io.Resource;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.concurrent.ExecutorConfigurationSupport;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.FileCopyUtils;

public class DefaultModulesLoader
extends LoggingObject
implements ModulesLoader {
    private DatabaseClient client;
    private AssetFileLoader assetFileLoader;
    private ExtensionMetadataProvider extensionMetadataProvider;
    private ModulesManager modulesManager;
    private StaticChecker staticChecker;
    private TaskExecutor taskExecutor;
    private int taskThreadCount = 8;
    private boolean shutdownTaskExecutorAfterLoadingModules = true;
    private TokenReplacer tokenReplacer;
    private List<LoadModulesFailureListener> failureListeners = new ArrayList<LoadModulesFailureListener>();
    private boolean rethrowRestModulesFailure = true;
    private boolean catchExceptions = false;
    private Pattern includeFilenamePattern;

    public DefaultModulesLoader(AssetFileLoader assetFileLoader) {
        this();
        this.assetFileLoader = assetFileLoader;
    }

    public DefaultModulesLoader() {
        this.extensionMetadataProvider = new DefaultExtensionMetadataProvider();
        this.modulesManager = new PropertiesModuleManager();
        this.failureListeners.add(new SimpleLoadModulesFailureListener());
    }

    public void initializeDefaultTaskExecutor() {
        if (this.taskThreadCount > 1) {
            ThreadPoolTaskExecutor tpte = new ThreadPoolTaskExecutor();
            tpte.setCorePoolSize(this.taskThreadCount);
            tpte.setAwaitTerminationSeconds(600);
            tpte.setWaitForTasksToCompleteOnShutdown(true);
            tpte.afterPropertiesSet();
            this.taskExecutor = tpte;
        } else {
            this.taskExecutor = new SyncTaskExecutor();
        }
    }

    @Override
    public Set<Resource> loadModules(DatabaseClient client, ModulesFinder modulesFinder, String ... paths) {
        List<String> pathsList = Arrays.asList(paths);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Loading modules from paths: " + pathsList);
        }
        this.setDatabaseClient(client);
        if (this.modulesManager != null) {
            this.modulesManager.initialize();
        }
        Modules allModules = new Modules();
        for (String path : paths) {
            allModules.addModules(modulesFinder.findModules(path));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Finished loading modules from paths: " + pathsList);
        }
        return this.loadModules(allModules);
    }

    @Override
    public Set<Resource> loadModules(String baseDir, ModulesFinder modulesFinder, DatabaseClient client) {
        return this.loadModules(client, modulesFinder, baseDir);
    }

    protected Set<Resource> loadModules(Modules modules) {
        if (this.taskExecutor == null) {
            this.initializeDefaultTaskExecutor();
        }
        HashSet<Resource> loadedModules = new HashSet<Resource>();
        this.loadProperties(modules, loadedModules);
        this.loadNamespaces(modules, loadedModules);
        this.loadAssets(modules, loadedModules);
        this.loadQueryOptions(modules, loadedModules);
        this.loadTransforms(modules, loadedModules);
        this.loadResources(modules, loadedModules);
        this.waitForTaskExecutorToFinish();
        this.rethrowRestModulesFailureIfOneExists();
        return loadedModules;
    }

    protected void rethrowRestModulesFailureIfOneExists() {
        if (this.failureListeners != null && this.rethrowRestModulesFailure) {
            for (LoadModulesFailureListener listener : this.failureListeners) {
                Object o;
                if (!(listener instanceof Supplier) || !((o = ((Supplier)((Object)listener)).get()) instanceof Throwable)) continue;
                Throwable t = (Throwable)o;
                throw new RuntimeException("Error occurred while loading REST modules: " + t.getMessage(), t);
            }
        }
    }

    public void waitForTaskExecutorToFinish() {
        if (this.shutdownTaskExecutorAfterLoadingModules) {
            if (this.taskExecutor instanceof ExecutorConfigurationSupport) {
                ((ExecutorConfigurationSupport)this.taskExecutor).shutdown();
                this.taskExecutor = null;
            } else if (this.taskExecutor instanceof DisposableBean) {
                try {
                    ((DisposableBean)this.taskExecutor).destroy();
                }
                catch (Exception ex) {
                    this.logger.warn("Unexpected exception while calling destroy() on taskExecutor: " + ex.getMessage(), (Throwable)ex);
                }
                this.taskExecutor = null;
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("shutdownTaskExecutorAfterLoadingModules is set to false, so not shutting down taskExecutor");
        }
    }

    protected void loadProperties(Modules modules, Set<Resource> loadedModules) {
        Resource r = modules.getPropertiesFile();
        if (r == null || !r.exists() || this.ignoreResource(r)) {
            return;
        }
        File f = this.getFileFromResource(r);
        if (f != null && this.modulesManager != null && !this.modulesManager.hasFileBeenModifiedSinceLastLoaded(f)) {
            return;
        }
        ServerConfigurationManager mgr = this.client.newServerConfigManager();
        if (f.getName().endsWith("xml")) {
            this.applyXmlProperties(mgr, r, f);
        } else {
            this.applyJsonProperties(mgr, r, f);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Writing REST server configuration to MarkLogic; " + this.getDatabaseClientInfo(this.client));
            this.logger.info("Default document read transform: " + mgr.getDefaultDocumentReadTransform());
            this.logger.info("Transform all documents on read: " + mgr.getDefaultDocumentReadTransformAll());
            this.logger.info("Validate query options: " + mgr.getQueryOptionValidation());
            this.logger.info("Validate queries: " + mgr.getQueryValidation());
            this.logger.info("Output debugging: " + mgr.getServerRequestLogging());
            if (mgr.getUpdatePolicy() != null) {
                this.logger.info("Update policy: " + mgr.getUpdatePolicy().name());
            }
        }
        mgr.writeConfiguration();
        if (f != null && this.modulesManager != null) {
            this.modulesManager.saveLastLoadedTimestamp(f, new Date());
        }
        loadedModules.add(r);
    }

    protected void applyJsonProperties(ServerConfigurationManager mgr, Resource r, File file) {
        JsonNode node;
        ObjectMapper m = new ObjectMapper();
        try {
            node = m.readTree(r.getInputStream());
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to read JSON REST properties file: " + file.getAbsolutePath(), ex);
        }
        if (node.has("debug")) {
            mgr.setServerRequestLogging(Boolean.valueOf(node.get("debug").asBoolean()));
        }
        if (node.has("document-transform-all")) {
            mgr.setDefaultDocumentReadTransformAll(Boolean.valueOf(node.get("document-transform-all").asBoolean()));
        }
        if (node.has("document-transform-out")) {
            mgr.setDefaultDocumentReadTransform(node.get("document-transform-out").asText());
        }
        if (node.has("update-policy")) {
            mgr.setUpdatePolicy(ServerConfigurationManager.UpdatePolicy.valueOf((String)node.get("update-policy").asText()));
        }
        if (node.has("validate-options")) {
            mgr.setQueryOptionValidation(Boolean.valueOf(node.get("validate-options").asBoolean()));
        }
        if (node.has("validate-queries")) {
            mgr.setQueryValidation(Boolean.valueOf(node.get("validate-queries").asBoolean()));
        }
    }

    protected void applyXmlProperties(ServerConfigurationManager mgr, Resource r, File file) {
        Element root;
        try {
            root = new SAXBuilder().build(r.getInputStream()).getRootElement();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to read XML REST properties file: " + file.getAbsolutePath(), e);
        }
        for (Element child : root.getChildren()) {
            String value = child.getValue();
            String name = child.getName();
            if ("debug".equals(name)) {
                mgr.setServerRequestLogging(Boolean.valueOf(Boolean.parseBoolean(value)));
                continue;
            }
            if ("document-transform-all".equals(name)) {
                mgr.setDefaultDocumentReadTransformAll(Boolean.valueOf(Boolean.parseBoolean(value)));
                continue;
            }
            if ("document-transform-out".equals(name)) {
                mgr.setDefaultDocumentReadTransform(value);
                continue;
            }
            if ("update-policy".equals(name)) {
                mgr.setUpdatePolicy(ServerConfigurationManager.UpdatePolicy.valueOf((String)value));
                continue;
            }
            if ("validate-options".equals(name)) {
                mgr.setQueryOptionValidation(Boolean.valueOf(Boolean.parseBoolean(value)));
                continue;
            }
            if (!"validate-queries".equals(name)) continue;
            mgr.setQueryValidation(Boolean.valueOf(Boolean.parseBoolean(value)));
        }
    }

    protected File getFileFromResource(Resource r) {
        try {
            return r.getFile();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected void loadAssets(Modules modules, Set<Resource> loadedModules) {
        List<Resource> dirs = modules.getAssetDirectories();
        if (dirs == null || dirs.isEmpty()) {
            return;
        }
        String[] paths = new String[dirs.size()];
        for (int i = 0; i < dirs.size(); ++i) {
            try {
                paths[i] = dirs.get(i).getURI().toString();
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Loading non-REST modules from paths: " + Arrays.asList(paths));
        }
        if (this.includeFilenamePattern != null) {
            this.applyIncludeFilenamePattern();
        }
        List<DocumentFile> list = null;
        try {
            list = this.assetFileLoader.loadFiles(paths);
        }
        catch (RuntimeException ex) {
            if (this.catchExceptions) {
                this.logger.error("Error loading modules: " + ex.getMessage());
            }
            throw ex;
        }
        if (this.staticChecker != null && list != null && !list.isEmpty()) {
            try {
                this.staticChecker.checkLoadedAssets(list);
            }
            catch (RuntimeException ex) {
                if (this.catchExceptions) {
                    this.logger.error("Static check failure: " + ex.getMessage());
                }
                throw ex;
            }
        }
        if (list != null) {
            for (DocumentFile asset : list) {
                loadedModules.add(asset.getResource());
            }
        }
    }

    protected void applyIncludeFilenamePattern() {
        this.assetFileLoader.initializeDocumentFileReader();
        DocumentFileReader dfr = this.assetFileLoader.getDocumentFileReader();
        if (dfr instanceof DefaultDocumentFileReader) {
            DefaultDocumentFileReader reader = (DefaultDocumentFileReader)dfr;
            reader.addDocumentFileProcessor(documentFile -> {
                File f = documentFile.getFile();
                if (f == null) {
                    return null;
                }
                if (!this.includeFilenamePattern.matcher(f.getAbsolutePath()).matches()) {
                    return null;
                }
                return documentFile;
            });
        }
    }

    protected void loadQueryOptions(Modules modules, Set<Resource> loadedModules) {
        if (modules.getOptions() == null) {
            return;
        }
        for (Resource r : modules.getOptions()) {
            if (this.installQueryOptions(r) == null) continue;
            loadedModules.add(r);
        }
    }

    protected void loadTransforms(Modules modules, Set<Resource> loadedModules) {
        if (modules.getTransforms() == null) {
            return;
        }
        for (Resource r : modules.getTransforms()) {
            try {
                ExtensionMetadataAndParams emap = this.extensionMetadataProvider.provideExtensionMetadataAndParams(r);
                if (this.installTransform(r, emap.metadata) == null) continue;
                loadedModules.add(r);
            }
            catch (RuntimeException e) {
                if (this.catchExceptions) {
                    this.logger.warn("Unable to load module from file: " + r.getFilename() + "; cause: " + e.getMessage(), (Throwable)e);
                    loadedModules.add(r);
                    this.updateTimestamp(r);
                    continue;
                }
                throw e;
            }
        }
    }

    protected void loadResources(Modules modules, Set<Resource> loadedModules) {
        if (modules.getServices() == null) {
            return;
        }
        for (Resource r : modules.getServices()) {
            try {
                ExtensionMetadataAndParams emap = this.extensionMetadataProvider.provideExtensionMetadataAndParams(r);
                if (this.installService(r, emap.metadata, emap.methods.toArray(new ResourceExtensionsManager.MethodParameters[0])) == null) continue;
                loadedModules.add(r);
            }
            catch (RuntimeException e) {
                if (this.catchExceptions) {
                    this.logger.warn("Unable to load module from file: " + r.getFilename() + "; cause: " + e.getMessage(), (Throwable)e);
                    loadedModules.add(r);
                    this.updateTimestamp(r);
                    continue;
                }
                throw e;
            }
        }
    }

    protected void loadNamespaces(Modules modules, Set<Resource> loadedModules) {
        if (modules.getNamespaces() == null) {
            return;
        }
        for (Resource r : modules.getNamespaces()) {
            if (this.installNamespace(r) == null) continue;
            loadedModules.add(r);
        }
    }

    public Resource installService(Resource r, ExtensionMetadata metadata, ResourceExtensionsManager.MethodParameters ... methodParams) {
        if (!this.hasFileBeenModified(r) || this.ignoreResource(r)) {
            return null;
        }
        ResourceExtensionsManager extMgr = this.client.newServerConfigManager().newResourceExtensionsManager();
        String resourceName = this.getExtensionNameFromFile(r);
        if (metadata.getTitle() == null) {
            metadata.setTitle(resourceName + " resource extension");
        }
        this.logger.info(String.format("Loading %s resource extension from file %s", resourceName, r.getFilename()));
        StringHandle h = new StringHandle(this.readAndReplaceTokens(r));
        this.executeTask(() -> {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.format("Writing %s resource extension to MarkLogic; %s", resourceName, this.getDatabaseClientInfo(this.client)));
            }
            extMgr.writeServices(resourceName, (TextWriteHandle)h, metadata, methodParams);
        });
        this.updateTimestamp(r);
        return r;
    }

    public Resource installTransform(Resource r, ExtensionMetadata metadata) {
        if (!this.hasFileBeenModified(r) || this.ignoreResource(r)) {
            return null;
        }
        String filename = r.getFilename();
        TransformExtensionsManager mgr = this.client.newServerConfigManager().newTransformExtensionsManager();
        String transformName = this.getExtensionNameFromFile(r);
        this.logger.info(this.format("Loading %s transform from resource %s", transformName, filename));
        StringHandle h = new StringHandle(this.readAndReplaceTokens(r));
        this.executeTask(() -> {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.format("Writing %s transform to MarkLogic; %s", transformName, this.getDatabaseClientInfo(this.client)));
            }
            if (FilenameUtil.isXslFile(filename)) {
                mgr.writeXSLTransform(transformName, (XMLWriteHandle)h, metadata);
            } else if (FilenameUtil.isJavascriptFile(filename)) {
                mgr.writeJavascriptTransform(transformName, (TextWriteHandle)h, metadata);
            } else {
                mgr.writeXQueryTransform(transformName, (TextWriteHandle)h, metadata);
            }
        });
        this.updateTimestamp(r);
        return r;
    }

    public Resource installQueryOptions(Resource r) {
        if (!this.hasFileBeenModified(r) || this.ignoreResource(r)) {
            return null;
        }
        String filename = r.getFilename();
        String name = this.getExtensionNameFromFile(r);
        this.logger.info(String.format("Loading %s query options from file %s", name, filename));
        QueryOptionsManager mgr = this.client.newServerConfigManager().newQueryOptionsManager();
        StringHandle h = new StringHandle(this.readAndReplaceTokens(r));
        this.executeTask(() -> {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.format("Writing %s query options to MarkLogic; %s", name, this.getDatabaseClientInfo(this.client)));
            }
            if (filename.endsWith(".json")) {
                mgr.writeOptions(name, (QueryOptionsWriteHandle)h.withFormat(Format.JSON));
            } else {
                mgr.writeOptions(name, (QueryOptionsWriteHandle)h);
            }
        });
        this.updateTimestamp(r);
        return r;
    }

    protected String readAndReplaceTokens(Resource r) {
        String content;
        try {
            content = new String(FileCopyUtils.copyToByteArray((InputStream)r.getInputStream()));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read content from: " + r.getDescription() + "; cause: " + e.getMessage(), e);
        }
        if (this.tokenReplacer != null) {
            content = this.tokenReplacer.replaceTokens(content);
        }
        return content;
    }

    protected void executeTask(Runnable r) {
        if (this.taskExecutor == null) {
            this.initializeDefaultTaskExecutor();
        }
        this.taskExecutor.execute(() -> {
            try {
                r.run();
            }
            catch (Exception e) {
                this.failureListeners.forEach(listener -> listener.processFailure(e, this.client));
            }
        });
    }

    public Resource installNamespace(Resource r) {
        String namespaceUri;
        if (!this.hasFileBeenModified(r) || this.ignoreResource(r)) {
            return null;
        }
        String prefix = this.getExtensionNameFromFile(r);
        try {
            namespaceUri = new String(FileCopyUtils.copyToByteArray((InputStream)r.getInputStream()));
        }
        catch (IOException ie) {
            this.logger.error("Unable to install namespace from file: " + r.getFilename(), (Throwable)ie);
            return null;
        }
        NamespacesManager mgr = this.client.newServerConfigManager().newNamespacesManager();
        String existingUri = mgr.readPrefix(prefix);
        if (existingUri != null) {
            this.logger.info(String.format("Deleting namespace with prefix of %s and URI of %s", prefix, existingUri));
            mgr.deletePrefix(prefix);
        }
        this.logger.info(String.format("Adding namespace with prefix of %s and URI of %s", prefix, namespaceUri));
        mgr.addPrefix(prefix, namespaceUri);
        this.updateTimestamp(r);
        return r;
    }

    protected String getExtensionNameFromFile(Resource r) {
        String name = r.getFilename();
        int pos = name.lastIndexOf(46);
        if (pos < 0) {
            return name;
        }
        return name.substring(0, pos);
    }

    protected boolean ignoreResource(Resource r) {
        if (this.includeFilenamePattern != null) {
            File file;
            block4: {
                file = null;
                try {
                    file = r.getFile();
                }
                catch (IOException e) {
                    if (!this.logger.isInfoEnabled()) break block4;
                    this.logger.info("Cannot resolve a File for resource: " + r + "; cannot determine if file should be ignored or not; cause: " + e.getMessage());
                }
            }
            if (file != null && !this.includeFilenamePattern.matcher(file.getAbsolutePath()).matches()) {
                return true;
            }
        }
        return false;
    }

    public void setDatabaseClient(DatabaseClient client) {
        this.client = client;
    }

    public void setExtensionMetadataProvider(ExtensionMetadataProvider extensionMetadataProvider) {
        this.extensionMetadataProvider = extensionMetadataProvider;
    }

    public void setModulesManager(ModulesManager modulesManager) {
        this.modulesManager = modulesManager;
    }

    public boolean isCatchExceptions() {
        return this.catchExceptions;
    }

    public void setCatchExceptions(boolean catchExceptions) {
        this.catchExceptions = catchExceptions;
    }

    public ExtensionMetadataProvider getExtensionMetadataProvider() {
        return this.extensionMetadataProvider;
    }

    public ModulesManager getModulesManager() {
        return this.modulesManager;
    }

    public void setStaticChecker(StaticChecker staticChecker) {
        this.staticChecker = staticChecker;
    }

    public StaticChecker getStaticChecker() {
        return this.staticChecker;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setTaskThreadCount(int taskThreadCount) {
        this.taskThreadCount = taskThreadCount;
    }

    public void setShutdownTaskExecutorAfterLoadingModules(boolean shutdownTaskExecutorAfterLoadingModules) {
        this.shutdownTaskExecutorAfterLoadingModules = shutdownTaskExecutorAfterLoadingModules;
    }

    public void setAssetFileLoader(AssetFileLoader assetFileLoader) {
        this.assetFileLoader = assetFileLoader;
    }

    public void addFailureListener(LoadModulesFailureListener listener) {
        this.failureListeners.add(listener);
    }

    public void removeFailureListener(LoadModulesFailureListener listener) {
        this.failureListeners.remove(listener);
    }

    private boolean hasFileBeenModified(Resource resource) {
        boolean modified = true;
        if (this.modulesManager != null) {
            try {
                File file = resource.getFile();
                modified = this.modulesManager.hasFileBeenModifiedSinceLastLoaded(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return modified;
    }

    private void updateTimestamp(Resource resource) {
        if (this.modulesManager != null) {
            try {
                File file = resource.getFile();
                this.modulesManager.saveLastLoadedTimestamp(file, new Date());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected String getDatabaseClientInfo(DatabaseClient client) {
        String info = this.format("port: %d", client.getPort());
        if (client.getDatabase() != null) {
            info = info + this.format("; database: %s", client.getDatabase());
        }
        return info;
    }

    public AssetFileLoader getAssetFileLoader() {
        return this.assetFileLoader;
    }

    public List<LoadModulesFailureListener> getFailureListeners() {
        return this.failureListeners;
    }

    public TokenReplacer getTokenReplacer() {
        return this.tokenReplacer;
    }

    public void setTokenReplacer(TokenReplacer tokenReplacer) {
        this.tokenReplacer = tokenReplacer;
    }

    public void setIncludeFilenamePattern(Pattern includeFilenamePattern) {
        this.includeFilenamePattern = includeFilenamePattern;
    }

    public void setRethrowRestModulesFailure(boolean rethrowRestModulesFailure) {
        this.rethrowRestModulesFailure = rethrowRestModulesFailure;
    }
}

