/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.file;

import com.marklogic.client.ext.file.PropertiesDrivenDocumentFileProcessor;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Properties;
import java.util.Stack;

abstract class CascadingPropertiesDrivenDocumentFileProcessor
extends PropertiesDrivenDocumentFileProcessor
implements FileVisitor<Path> {
    private final Stack<Properties> propertiesStack = new Stack();
    private boolean cascadingEnabled = false;

    protected CascadingPropertiesDrivenDocumentFileProcessor(String propertiesFilename) {
        super(propertiesFilename);
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        File propertiesFile;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.format("Visiting directory: %s", dir.toFile().getAbsolutePath()));
        }
        if ((propertiesFile = new File(dir.toFile(), this.getPropertiesFilename())).exists()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.format("Loading properties from file: %s", propertiesFile.getAbsolutePath()));
            }
            this.loadProperties(propertiesFile);
        } else if (this.cascadingEnabled && !this.propertiesStack.isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("No properties file, and cascading is enabled, so using properties from top of stack.");
            }
            this.setProperties(this.propertiesStack.peek());
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("No properties file, or cascading is disabled, so using empty properties.");
            }
            this.setProperties(new Properties());
        }
        this.propertiesStack.push(this.getProperties());
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
        this.propertiesStack.pop();
        if (!this.propertiesStack.isEmpty()) {
            this.setProperties(this.propertiesStack.peek());
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) {
        return FileVisitResult.CONTINUE;
    }

    public boolean isCascadingEnabled() {
        return this.cascadingEnabled;
    }

    public void setCascadingEnabled(boolean cascadingEnabled) {
        this.cascadingEnabled = cascadingEnabled;
    }
}

