/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.batch;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.datamovement.Batcher;
import com.marklogic.client.datamovement.DataMovementManager;
import com.marklogic.client.datamovement.JobTicket;
import com.marklogic.client.datamovement.WriteBatcher;
import com.marklogic.client.document.DocumentWriteOperation;
import com.marklogic.client.ext.batch.BatchWriter;
import com.marklogic.client.ext.helper.LoggingObject;
import java.util.List;

public class DataMovementBatchWriter
extends LoggingObject
implements BatchWriter {
    private DatabaseClient client;
    private DataMovementManager dataMovementManager;
    private WriteBatcher writeBatcher;
    private int batchSize = 100;
    private int threadCount = 10;
    private JobTicket jobTicket;

    public DataMovementBatchWriter(DatabaseClient client) {
        this.client = client;
        this.dataMovementManager = client.newDataMovementManager();
    }

    @Override
    public void initialize() {
        this.writeBatcher = this.dataMovementManager.newWriteBatcher();
        this.writeBatcher.withThreadCount(this.threadCount);
        this.writeBatcher.withBatchSize(this.batchSize);
        this.jobTicket = this.dataMovementManager.startJob(this.writeBatcher);
    }

    @Override
    public void write(List<? extends DocumentWriteOperation> items) {
        for (DocumentWriteOperation documentWriteOperation : items) {
            this.writeBatcher.add(documentWriteOperation.getUri(), documentWriteOperation.getMetadata(), documentWriteOperation.getContent());
        }
    }

    @Override
    public void waitForCompletion() {
        if (this.writeBatcher != null) {
            this.writeBatcher.flushAndWait();
            if (this.jobTicket != null) {
                this.dataMovementManager.stopJob((Batcher)this.writeBatcher);
            } else {
                this.dataMovementManager.stopJob((Batcher)this.writeBatcher);
            }
        }
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }
}

