/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.tokenreplacer;

import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.client.ext.tokenreplacer.PropertiesSource;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;

public class FilePropertiesSource
extends LoggingObject
implements PropertiesSource {
    private Properties props;
    private File file;

    public FilePropertiesSource(File file) {
        this.file = file;
    }

    @Override
    public Properties getProperties() {
        if (this.props == null) {
            this.props = this.loadPropertiesFromFile(this.file);
        }
        return this.props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadPropertiesFromFile(File file) {
        Properties properties = new Properties();
        if (file.exists()) {
            FileReader reader = null;
            try {
                reader = new FileReader(file);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Loading properties from: " + file.getAbsolutePath());
                }
                properties.load(reader);
            }
            catch (IOException ex) {
                this.logger.warn("Unable to load properties from file " + file.getAbsolutePath() + "; cause: " + ex.getMessage(), (Throwable)ex);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return properties;
    }
}

