/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.modulesloader.impl;

import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.client.ext.modulesloader.Modules;
import com.marklogic.client.ext.modulesloader.ModulesFinder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public abstract class BaseModulesFinder
extends LoggingObject
implements ModulesFinder {
    private ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
    private boolean includeUnrecognizedPathsAsAssetPaths = true;
    private String servicesPath = "services";
    private String optionsPath = "options";
    private String namespacesPath = "namespaces";
    private String transformsPath = "transforms";
    private String schemasPath = "schemas";

    protected void addPropertiesFile(Modules modules, String baseDir) {
        List<Resource> resources = this.findResources("REST properties file", baseDir, "rest-properties.json", "rest-properties.xml");
        for (Resource r : resources) {
            if (!r.exists()) continue;
            modules.setPropertiesFile(r);
            break;
        }
    }

    protected void addAssetDirectories(Modules modules, String baseDir) {
        ArrayList<Resource> dirs = new ArrayList<Resource>();
        List<String> recognizedPaths = this.getRecognizedPaths();
        this.findResources("non-REST module directories", baseDir, "*", "*/").stream().forEach(resource -> {
            try {
                String resourceFile = resource.getURL().getFile();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Checking resource to see if it's a valid non-REST module directory: " + resourceFile);
                }
                resourceFile = this.decodeAssetDirectoryResource(resourceFile);
                File f = new File(resourceFile);
                String uri = resource.getURI().toString();
                boolean isRecognized = recognizedPaths.contains(f.getName());
                boolean hasWeirdWarPath = uri.contains("jar:war");
                if (!isRecognized && !hasWeirdWarPath) {
                    boolean notInList;
                    boolean isDir = resource instanceof FileSystemResource && f.isDirectory();
                    boolean isUrlResource = resource instanceof UrlResource;
                    boolean bl = notInList = dirs.indexOf(resource) < 0;
                    if ((isDir || isUrlResource) && notInList) {
                        dirs.add((Resource)resource);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        modules.setAssetDirectories(dirs);
    }

    protected String decodeAssetDirectoryResource(String resourceFile) {
        if (resourceFile.contains("%20")) {
            resourceFile = resourceFile.replaceAll("%20", " ");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Replaced occurrences of %20 with a space in potential non-REST module directory: " + resourceFile);
            }
        }
        return resourceFile;
    }

    protected List<String> getRecognizedPaths() {
        return Arrays.asList(this.optionsPath, this.servicesPath, this.transformsPath, this.namespacesPath, this.schemasPath);
    }

    protected void addNamespaces(Modules modules, String baseDir) {
        modules.setNamespaces(this.findResources("namespaces", baseDir, this.namespacesPath + "/*.*"));
    }

    protected void addOptions(Modules modules, String baseDir) {
        modules.setOptions(this.findResources("options modules", baseDir, this.optionsPath + "/*.xml", this.optionsPath + "/*.json"));
    }

    protected void addServices(Modules modules, String baseDir) {
        modules.setServices(this.findResources("service modules", baseDir, this.servicesPath + "/*.xq*", this.servicesPath + "/*.sjs"));
    }

    protected void addTransforms(Modules modules, String baseDir) {
        modules.setTransforms(this.findResources("transform modules", baseDir, this.transformsPath + "/*.xq*", this.transformsPath + "/*.xsl*", this.transformsPath + "/*.sjs"));
    }

    protected List<Resource> findResources(String moduleType, String basePath, String ... paths) {
        ArrayList<Resource> list = new ArrayList<Resource>();
        for (String path : paths) {
            try {
                Object finalPath = basePath;
                if (!((String)finalPath).endsWith("/") && !path.startsWith("/")) {
                    finalPath = (String)finalPath + "/";
                }
                finalPath = (String)finalPath + path;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Finding " + moduleType + " at path: " + (String)finalPath);
                }
                Resource[] r = this.resolver.getResources((String)finalPath);
                list.addAll(Arrays.asList(r));
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to find resources at path: " + path, e);
            }
        }
        return list;
    }

    public void setServicesPath(String servicesPath) {
        this.servicesPath = servicesPath;
    }

    public void setOptionsPath(String optionsPath) {
        this.optionsPath = optionsPath;
    }

    public void setNamespacesPath(String namespacesPath) {
        this.namespacesPath = namespacesPath;
    }

    public void setTransformsPath(String transformsPath) {
        this.transformsPath = transformsPath;
    }

    public boolean isIncludeUnrecognizedPathsAsAssetPaths() {
        return this.includeUnrecognizedPathsAsAssetPaths;
    }

    public void setIncludeUnrecognizedPathsAsAssetPaths(boolean includeUnrecognizedPathsAsAssetPaths) {
        this.includeUnrecognizedPathsAsAssetPaths = includeUnrecognizedPathsAsAssetPaths;
    }

    @Override
    public final Modules findModules(String baseDir) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Finding modules in baseDir: " + baseDir);
        }
        if (!baseDir.startsWith("file:") && !baseDir.startsWith("classpath")) {
            baseDir = new File(baseDir).toURI().toString();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Finding modules in baseDir, which was modified to be: " + baseDir);
            }
        }
        return this.findModulesWithResolvedBaseDir(baseDir);
    }

    protected abstract Modules findModulesWithResolvedBaseDir(String var1);
}

