/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.modulesloader.impl;

import com.marklogic.client.ext.file.DocumentFile;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.client.ext.modulesloader.impl.StaticChecker;
import com.marklogic.client.io.Format;
import java.util.List;

public abstract class AbstractStaticChecker
extends LoggingObject
implements StaticChecker {
    private boolean checkLibraryModules = false;
    private boolean bulkCheck = false;

    @Override
    public void checkLoadedAssets(List<DocumentFile> assets) {
        if (assets == null || assets.isEmpty()) {
            return;
        }
        if (this.bulkCheck) {
            this.performBulkStaticCheck(assets);
        } else {
            for (DocumentFile asset : assets) {
                if (!this.canBeStaticallyChecked(asset)) continue;
                this.staticallyCheckModule(asset.getUri());
            }
        }
    }

    protected abstract void executeQuery(String var1);

    protected void staticallyCheckModule(String uri) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Performing static check on module at URI: " + uri);
        }
        String xquery = "let $uri := '" + uri + "' return " + this.buildXqueryForStaticallyCheckingModule();
        this.executeQuery(xquery);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Finished static check on module at URI: " + uri);
        }
    }

    protected boolean canBeStaticallyChecked(DocumentFile asset) {
        Format format = asset.getFormat();
        return format != null && (format.equals((Object)Format.JSON) || format.equals((Object)Format.TEXT) || format.equals((Object)Format.XML));
    }

    protected void performBulkStaticCheck(List<DocumentFile> assets) {
        Object xquery = "let $uris := (";
        for (DocumentFile asset : assets) {
            if (!this.canBeStaticallyChecked(asset)) continue;
            String uri = asset.getUri();
            if (!((String)xquery).endsWith("(")) {
                xquery = (String)xquery + ",";
            }
            xquery = (String)xquery + "'" + uri + "'";
        }
        xquery = (String)xquery + ") for $uri in $uris return " + this.buildXqueryForStaticallyCheckingModule();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Static checking all loaded modules");
        }
        this.executeQuery((String)xquery);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Finished static checking all loaded modules");
        }
    }

    protected String buildXqueryForStaticallyCheckingModule() {
        Object xquery = "try { xdmp:invoke($uri, (), <options xmlns='xdmp:eval'><static-check>true</static-check></options>) } catch ($e) { if ($e/*:code = 'XDMP-NOEXECUTE') then () else if ($e/*:code = 'XDMP-EVALLIBMOD') then ";
        xquery = this.checkLibraryModules ? (String)xquery + "  let $doc := xdmp:eval('declare variable $URI external; fn:doc($URI)', (xs:QName('URI'), $uri), <options xmlns='xdmp:eval'><database>{xdmp:modules-database()}</database></options>)   let $line := fn:tokenize($doc, '\n')[fn:contains(., 'module namespace')][1]   let $ns := fn:tokenize($line, '=')[2]   let $ns := fn:replace($ns, ';', '')   let $ns := fn:replace($ns, \"'\", \"\")   let $ns := fn:normalize-space(fn:replace($ns, '\"', ''))   let $xquery := fn:concat('import module namespace ns = \"', $ns, '\" at \"', $uri, '\"; ()')  return xdmp:eval($xquery, (), <options xmlns='xdmp:eval'><static-check>true</static-check></options>) " : (String)xquery + " () ";
        return (String)xquery + " else xdmp:rethrow() }";
    }

    public void setCheckLibraryModules(boolean checkLibraryModules) {
        this.checkLibraryModules = checkLibraryModules;
    }

    public void setBulkCheck(boolean bulkCheck) {
        this.bulkCheck = bulkCheck;
    }
}

